<?php
/**
 * @package BuddyBoss Child
 * The parent theme functions are located at /buddyboss-theme/inc/theme/functions.php
 * Add your own functions at the bottom of this file.
 */


/****************************** THEME SETUP ******************************/

/**
 * Sets up theme for translation
 *
 * @since BuddyBoss Child 1.0.0
 */
function buddyboss_theme_child_languages()
{
  /**
   * Makes child theme available for translation.
   * Translations can be added into the /languages/ directory.
   */

  // Translate text from the PARENT theme.
  load_theme_textdomain( 'buddyboss-theme', get_stylesheet_directory() . '/languages' );

  // Translate text from the CHILD theme only.
  // Change 'buddyboss-theme' instances in all child theme files to 'buddyboss-theme-child'.
  // load_theme_textdomain( 'buddyboss-theme-child', get_stylesheet_directory() . '/languages' );

}
add_action( 'after_setup_theme', 'buddyboss_theme_child_languages' );

/**
 * Enqueues scripts and styles for child theme front-end.
 *
 * @since Boss Child Theme  1.0.0
 */
function buddyboss_theme_child_scripts_styles()
{
  /**
   * Scripts and Styles loaded by the parent theme can be unloaded if needed
   * using wp_deregister_script or wp_deregister_style.
   *
   * See the WordPress Codex for more information about those functions:
   * http://codex.wordpress.org/Function_Reference/wp_deregister_script
   * http://codex.wordpress.org/Function_Reference/wp_deregister_style
   **/

  // Styles
  wp_enqueue_style( 'buddyboss-child-css', get_stylesheet_directory_uri().'/assets/css/custom.css' );

  // Javascript
  wp_enqueue_script( 'buddyboss-child-js', get_stylesheet_directory_uri().'/assets/js/custom.js' );
}
add_action( 'wp_enqueue_scripts', 'buddyboss_theme_child_scripts_styles', 9999 );


/****************************** CUSTOM FUNCTIONS ******************************/

// Add your own custom functions here

//Set javascript variable to draw lines between creators
//add_action('wp_head', 'setCreatorNodesVariable');
function setCreatorNodesVariable() {
    require_once __DIR__ . '/../../../wp-load.php';
    global $wpdb;

    /*
    project table => "wprsiun_bp_groups" (has creator_id)
    table rel term_id/project_id => "wprsiun_term_relationships"
    term name => "wprsiun_terms"
    term rel with users => "wprsiun_term_taxonomy"
    */


    //category
    /*$termsQuery = "SELECT
    term.term_id as id,
    term.slug as slug,
    term.name as name
    FROM {$wpdb->prefix}term_taxonomy as taxonomy
    INNER JOIN {$wpdb->prefix}terms as term on taxonomy.term_id = term.term_id";*/
	
	//TODO: INNER JOIN w/ bp_groups_members and JOIN w/ users (get thumb)

    $projectsQuery = "SELECT
    project.id as id,
    project.name as name,
    project.creator_id as creatorId,
    categoryRel.term_taxonomy_id as categoryId,
    category.slug as categoryName
    FROM {$wpdb->prefix}bp_groups as project
    INNER JOIN {$wpdb->prefix}bp_xprofile_data as creator on creator.user_id = project.creator_id
    INNER JOIN {$wpdb->prefix}term_relationships as categoryRel on categoryRel.object_id = project.id
    INNER JOIN {$wpdb->prefix}terms as category on category.term_id = categoryRel.term_taxonomy_id
    GROUP BY id,name,creatorId,categoryId
    ";

    $results = [];
    $results = $wpdb->get_results( $projectsQuery );

    echo "<script>
        var creatorNodes = `". json_encode( $results ) ."`
        creatorNodes = JSON.parse( creatorNodes );
    </script>";
}

//call the network
function networkcall (){
    //return 'O Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500, quando uma misturou os caracteres de um texto para criar um espécime de livro. Este texto não só sobreviveu 5 séculos, mas também o salto para a tipografia electrónica, mantendo-se essencialmente inalterada. Foi popularizada nos anos 60 com a disponibilização das folhas de Letraset, que continham passagens com Lorem Ipsum, e mais recentemente com os programas de publicação como o Aldus PageMaker que incluem versões do Lorem Ipsum.';
    require_once "/home/akisport/public_html/wp-content/plugins/mobinteg-network/networkv2.php";
    //require_once "/home/akisport/public_html/wp-content/plugins/mobinteg-wp/tests/network.php";
}

//commnet fcp
//add_shortcode('network', 'networkcall');

/*
<div id="mynetwork" style="height:600px">[network]</div>
*/

?>
