<?php
/**
 * @package BuddyBoss\Search
 * @since   BuddyBoss 1.0.0
 * @todo    add description
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Bp_Search_Tabs' ) ) :

    /**
     * BuddyPress Global Search  - search tabs class
     */
    class Bp_Search_Tabs extends Bp_Search_Type {
        private $type = 'tabs';

        /**
         * Insures that only one instance of Class exists in memory at any
         * one time. Also prevents needing to define globals all over the place.
         *
         * @since BuddyBoss 1.0.0
         *
         * @return object Bp_Search_Tabs
         */
        public static function instance() {
            // Store the instance locally to avoid private static replication
            static $instance = null;

            // Only run these methods if they haven't been run previously
            if ( null === $instance ) {
                $instance = new Bp_Search_Tabs();
            }

            // Always return the instance
            return $instance;
        }

        /**
         * A dummy constructor to prevent this class from being loaded more than once.
         *
         * @since BuddyBoss 1.0.0
         */
        private function __construct() {
            /* Do nothing here */
        }

        public function sql( $search_term, $only_totalrow_count = false ) {
            global $wpdb;

            $search_term = htmlspecialchars( $search_term, ENT_QUOTES | ENT_SUBSTITUTE | ENT_HTML401 );

            $sql['select'] = 'SELECT';

            if ( $only_totalrow_count ) {
                $sql['select'] .= ' COUNT( DISTINCT p.ID ) ';
            } else {
                $sql['select'] .= $wpdb->prepare( " DISTINCT p.ID, 'tabs' as type, p.post_title LIKE %s AS relevance, p.post_date as entry_date ", '%' . $wpdb->esc_like( $search_term ) . '%' );
            }

            $sql['from'] = " FROM {$wpdb->posts} p ";

            $where_conditions = array( '1=1' );
            

            // Add a condition to search within the custom post meta field '_bpgtc_subnav_items'.
            $where_conditions['search_query'] .= $wpdb->prepare(
                " EXISTS ( SELECT * FROM {$wpdb->postmeta} WHERE post_id = p.ID AND meta_key = '_bpgtc_subnav_items' AND meta_value LIKE %s )",
                '%' . $wpdb->esc_like( $search_term ) . '%'
            );

            /**
             * Add additional conditions or custom logic here if needed.
             */

            // Join the where conditions together.
            $sql['where'] = 'WHERE ' . join( ' AND ', $where_conditions );

            $sql = "{$sql['select']} {$sql['from']} {$sql['where']}";

            $sql = $wpdb->prepare( $sql );

            return apply_filters(
                'Bp_Search_Tabs_sql',
                $sql,
                array(
                    'search_term'         => $search_term,
                    'only_totalrow_count' => $only_totalrow_count,
                )
            );
        }

        protected function generate_html( $template_type = '' ) {
            // Retrieve search results for your custom post type 'bpgtc_group_tab'.
            $args = array(
                'post_type'      => 'bpgtc_group_tab',
                'posts_per_page' => -1, // Retrieve all matching posts.
            );

            $custom_query = new WP_Query( $args );

            if ( $custom_query->have_posts() ) {
                foreach ( $custom_query->get_posts() as $post ) {
                    $group_ids = get_post_meta($post->ID,'_bpgtc_tab_groups',true);
                    
                    $args = array(
                        'include'      => $group_ids,
                        'per_page'     => count( $group_ids ),
                        'search_terms' => false,
                    );
                    if ( is_user_logged_in() ) {
                        $args['show_hidden'] = true;
                    }
                    
                    if ( bp_has_groups( $args ) ) {
                        while ( bp_groups() ) {
                            bp_the_group();
        
                            $result = array(
                                'id'    => bp_get_group_id(),
                                'type'  => $this->type,
                                'title' => bp_get_group_name(),
                                'html'  => bp_search_buffer_template_part( 'loop/tabs', $template_type, false ),
                            );
        
                            $this->search_results['items'][  $post->ID  ] = $result;
                        }
                    }
                }
            }

            wp_reset_postdata();
        }
    }

    // End class Bp_Search_Tabs

endif;

add_filter('bp_search_additional_search_helpers', 'tab_filters');
function tab_filters($data) {
    $data['tabs'] = Bp_Search_Tabs::instance();
    return $data;
}
