<?php

/**
 * Plugin Name: mobinteg Network
 * Description: WP plugin developed by mobinteg.com
 * Author: mobinteg.com
 * Author URI: https://mobinteg.com
 * Version: 1.1.0
 */

function network_diagram_scripts()
{
    $jq_js = date("ymd-Gis", filemtime(plugin_dir_path(__FILE__) . 'js/jqueryui.js'));
    wp_enqueue_script('jqui', plugins_url('js/jqueryui.js', __FILE__), array(), $jq_js);

    $vis_js = date("ymd-Gis", filemtime(plugin_dir_path(__FILE__) . 'js/vis.js'));
    wp_enqueue_script('vis', plugins_url('js/vis.js', __FILE__), array(), $vis_js);

    $network_diagram_js = date("ymd-Gis", filemtime(plugin_dir_path(__FILE__) . 'js/network-diagram.js'));
    wp_enqueue_script('network-diagram', plugins_url('js/network-diagram.js', __FILE__), array(), $network_diagram_js);

    $network_data_js = date("ymd-Gis", filemtime(plugin_dir_path(__FILE__) . 'network-data.php'));
    wp_enqueue_script('network-data', plugins_url('network-data.php', __FILE__), array(), $network_data_js);

    $vis_css = date("ymd-Gis", filemtime(plugin_dir_path(__FILE__) . 'css/vis.css'));
    wp_enqueue_style('vis', plugins_url('css/vis.css', __FILE__), array(), $vis_css);
}

if (strpos(home_url($_SERVER['REQUEST_URI']), "/rede-social/") !== false) {
    add_action('wp_enqueue_scripts', 'network_diagram_scripts');
}


function network_diagram_shortcode() {

    $member_types = bp_get_member_types(array(), 'objects');
    $type_select = '';
    if ($member_types):
        $type_select = '<select id="network-filter-dropdown">';
        $type_select .= '<option value="">' . __('Todos', 'mobinteg') . '</option>';
        foreach ($member_types as $key => $val):
            $type_select .= '<option '.($val->directory_slug=='instituicao'?'selected':'').' value="' . $val->directory_slug . '">' . $val->labels['name'] . '</option>';
        endforeach;
        $type_select .= '</select>';
    endif;

    $html='
    <div id="allnetwork">
    '.$type_select.'
        <div id="mynetwork" style="height:600px">
        </div>
    </div>';

    return $html;
}
add_shortcode('network-diagram', 'network_diagram_shortcode');
