<?php
namespace LearnDash\Groups_Plus\Utility;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class Timer
 *
 * @package learndash_groups_plus
 */
class Timer {

	public static $timed_post_types = array( 'sfwd-courses', 'sfwd-lessons', 'sfwd-topic', 'sfwd-quiz' );

	/**
	 * Class constructor
	 */
	public function __construct() {
		self::run_frontend_hooks();
	}

	/*
	 * Initialize frontend actions and filters
	 */
	public static function run_frontend_hooks() {
		add_action( 'wp_ajax_timer_entry', array( __CLASS__, 'timer_entry' ) );

		// Store timer when course completion get triggered
		add_action( 'learndash_course_completed', array( __CLASS__, 'course_completed_store_timer' ) );

		// Return time spent on post( course, lesson, topic)
		add_shortcode( 'time', array( __CLASS__, 'shortcode_time' ) );

		// Return total time spent on all the courses enrolled
		add_shortcode( 'total_time', array( __CLASS__, 'shortcode_total_time' ) );

		// echo Timer::get_time_spent( get_post(25673 ) , get_current_user_id()); die;
	}

	public static function timer_entry() {
		global $wpdb;
		$return_object = array();

		if ( ! is_user_logged_in() ) {
			$return_object['success']             = false;
			$return_object['message']             = 'You must be logged in.';
			$return_object['fields']['course_id'] = $_GET['course_id'];
			$return_object['fields']['post_id']   = $_GET['post_id'];

			echo json_encode( $return_object );
			exit;
		}

		$course_ID = absint( $_POST['course_id'] );
		$post_ID   = absint( $_POST['post_id'] );
		$user_id   = get_current_user_id();

		if ( 0 === $post_ID ) {
			$return_object['success']             = false;
			$return_object['message']             = 'One or more the the fields did not validate as a absolute integer.';
			$return_object['fields']['course_id'] = $_GET['course_id'];
			$return_object['fields']['post_id']   = $_GET['post_id'];

			echo json_encode( $return_object );
			exit;
		}

		$meta_key = 'timer_' . $course_ID . '_' . $post_ID;

		$q = "SELECT meta_value FROM $wpdb->usermeta WHERE meta_key = '{$meta_key}' AND user_id = {$user_id}";

		// get var instead of get user meta
		$timer = $wpdb->get_var( $q );

		// $return_object['$timer'] = $timer;

		// Set timer default
		if ( empty( $timer ) ) {
			$timer = 0;
			// create user meta since it doesn't exist and we need a unique to update
			$wpdb->insert(
				$wpdb->usermeta,
				array(
					'user_id'    => $user_id,
					'meta_key'   => $meta_key,
					'meta_value' => 0,
				),
				array(
					'%d',
					'%s',
					'%d',
				)
			);
		}

		$q              = "SELECT umeta_id FROM $wpdb->usermeta WHERE meta_key = '{$meta_key}' AND user_id = {$user_id}";
		$timer_umeta_id = $wpdb->get_var( $q );

		// $return_object['$timer_umeta_id'] = $timer_umeta_id;

		// Amount of time added every call // JS interval must match
		$timer_interval = 10;

		// Set timer default, minimum is 10 seconds
		if ( '' === $timer_interval || (int) $timer_interval < 5 ) {
			$timer_interval = 15;
		}

		$timer += $timer_interval;

		$q = "UPDATE {$wpdb->usermeta} SET meta_value = {$timer} WHERE umeta_id = {$timer_umeta_id}";
		$wpdb->query( $q );

		$return_object['success'] = true;
		$return_object['time']    = $timer;

		// $q = "SELECT umeta_id FROM $wpdb->usermeta WHERE meta_key = 'session_tokens' AND user_id = {$current_user->ID}";
		// $session_umeta_id = $wpdb->get_var( $q );

		// $q = "UPDATE {$wpdb->usermeta} SET meta_value = '{$this->session_token}' WHERE umeta_id = {$session_umeta_id}";
		// $wpdb->query($q);

		// For debugging
		// $return_object['$meta_key'] = $meta_key;
		// $this->execution_time['end'] = microtime( true );
		// $exec_time = $this->execution_time['end'] - $this->execution_time['start'];
		// $return_object['execution_time']    = $exec_time;

		echo json_encode( $return_object );
		exit;
	}

	private static function convert_second_to_time( $second ) {

		if ( ! $second ) {
			return '00:00:00';
		}

		$hours   = floor( $second / 3600 );
		$second -= $hours * 3600;

		$minutes = floor( $second / 60 );
		$second -= $minutes * 60;

		if ( $hours < 10 ) {
			$hours = '0' . $hours;
		}
		if ( $minutes < 10 ) {
			$minutes = '0' . $minutes;
		}
		if ( $second < 10 ) {
			$second = '0' . $second;
		}

		$total_time = ( $hours ) ? $hours . ':' : '';
		$total_time = ( $minutes ) ? $total_time . $minutes . ':' : $total_time . '00:';
		$total_time = ( $second ) ? $total_time . $second : $total_time . '00';

		return $total_time;
	}

	public static function get_time_spent( $post_object, $user_ID ) {

		if ( $post_object->post_type == 'sfwd-courses' ) {

			// count all timed sections of course
			$course_cumulative_time = self::get_course_time_in_seconds( $post_object->ID, $user_ID );

			return self::convert_second_to_time( $course_cumulative_time );

		} elseif ( in_array( $post_object->post_type, self::$timed_post_types ) ) {
			// return specific time
			$course_ID = learndash_get_course_id( $post_object->ID );
			$meta_key  = 'timer_' . $course_ID . '_' . $post_object->ID;
			$timer     = get_user_meta( (int) $user_ID, $meta_key, true );

			return self::convert_second_to_time( (int) $timer );

		}

		return '';

	}

	private static function get_course_time_in_seconds( $course_id, $user_ID ) {

		global $wpdb;

		$completed_on_meta_key = 'timer_' . learndash_get_course_id( $course_id ) . '_%';

		$query_results = $wpdb->prepare( "SELECT SUM( meta_value ) FROM $wpdb->usermeta WHERE meta_key LIKE %s AND user_id = %d", $completed_on_meta_key, $user_ID );

		$timer_results = $wpdb->get_var( $query_results );

		return $timer_results;

	}

	public static function course_completed_store_timer( $data ) {

		$user_ID    = $data['user']->ID;
		$course     = $data['course'];
		$meta_key   = 'course_timer_completed_' . $course->ID;
		$meta_value = self::get_time_spent( $course, $user_ID );

		update_user_meta( $user_ID, $meta_key, $meta_value );

	}

	public static function shortcode_time( $attributes ) {
		$request = shortcode_atts(
			array(
				'user-id'   => '',
				'course-id' => '',
			),
			$attributes
		);

		if ( '' === $request['user-id'] ) {
			$request['user-id'] = get_current_user_id();
		}

		$user_ID = absint( $request['user-id'] );
		$post_ID = absint( $request['course-id'] );

		if ( '' == $request['course-id'] ) {
			global $post;

			if ( ( ! is_404() && ! is_archive() && is_a( $post, 'WP_Post' ) ) ) {
				$course_post = get_post( learndash_get_course_id( $post->ID ) );

				return self::get_time_spent( $course_post, $user_ID );
			}
		} elseif ( $post_ID ) {
			$requested_post = get_post( $post_ID );

			return self::get_time_spent( $requested_post, $user_ID );
		}

		return '';
	}

	public static function shortcode_total_time( $attributes ) {
		$request = shortcode_atts(
			array(
				'user-id' => '',
			),
			$attributes
		);

		if ( '' === $request['user-id'] ) {
			$request['user-id'] = get_current_user_id();
		}

		$enrolled_courses = learndash_user_get_enrolled_courses( $request['user-id'] );
		$total_time       = '';
		foreach ( $enrolled_courses as $enrolled_course ) {
			$course_cumulative_time = self::get_course_time_in_seconds( $enrolled_course, $request['user-id'] );
			if ( ! empty( $course_cumulative_time ) ) {
				$total_time = $total_time + $course_cumulative_time;
			}
		}

		return self::convert_second_to_time( $total_time );
	}
}
