<?php
namespace LearnDash\Groups_Plus\Utility;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class SharedFunctions
 *
 * @package learndash_groups_plus
 */
class SharedFunctions {
	/**
	 * @var string
	 */
	static $group_name_field = '_group_name';
	/**
	 * @var string
	 */
	static $seats_course_meta_field = '_groups_plus_seats_courses';
	/**
	 * @var string
	 */
	static $linked_group_id_meta = '_linked_group_id';

	/**
	 * @var string
	 */
	static $individual_seat_meta_field = '_is_individual_seat';

	/**
	 * @var string
	 */
	static $groups_plus_organization_courses_meta_field = '_groups_plus_organization_courses';

	/**
	 * @var string
	 */
	static $groups_plus_organization_groups_meta_field = '_groups_plus_organization_groups';

	/**
	 * @var string
	 */
	static $is_organization_purchase_enable = '_is_organization_purchase_enable';

	/**
	 * @var string
	 */
	static $is_organization_group_purchase_enable = '_is_organization_group_purchase_enable';

	/**
	 * @var string
	 */
	static $is_individual_seat_purchase_enable = '_is_individual_seat_purchase_enable';

	/**
	 * @var string
	 */
	static $variable_product_allow_seats = '_variable_product_allow_seats';

	/**
	 * Class constructor
	 */
	public function __construct() {

	}

	/**
	 * Check if WooCommerce is active
	 *
	 * @return bool
	 * @since 2.8.0
	 */
	public static function is_woocommerce_active() {
		include_once ABSPATH . 'wp-admin/includes/plugin.php';
		if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
			return true;
		} elseif ( is_plugin_active_for_network( 'woocommerce/woocommerce.php' ) ) {
			return true;
		} elseif ( class_exists( 'WooCommerce' ) ) {
			return true;
		} elseif ( function_exists( 'WC' ) ) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Check if WooCommerce Subscription is active
	 *
	 * @return bool
	 * @since 2.8.0
	 */
	public static function is_woocommerce_subscription_active() {
		include_once ABSPATH . 'wp-admin/includes/plugin.php';
		if ( is_plugin_active( 'woocommerce-subscriptions/woocommerce-subscriptions.php' ) ) {
			return true;
		} elseif ( is_plugin_active_for_network( 'woocommerce-subscriptions/woocommerce-subscriptions.php' ) ) {
			return true;
		} elseif ( class_exists( 'WC_Subscriptions' ) ) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * @param       $cache
	 * @param array $data
	 * @param null  $user_id
	 */
	public static function set_transient_cache( $cache, $data = array(), $user_id = null ) {
		if ( null === $user_id ) {
			$user_id = wp_get_current_user()->ID;
		}
		$cache = str_replace( 'USERID', $user_id, $cache );
		if ( is_multisite() ) {
			add_site_option( $cache, $data );
		} else {
			add_option( $cache, $data );
		}
	}


	/**
	 * @param null $cache
	 * @param null $user_id
	 * @param bool $is_transient
	 *
	 * @return false|mixed|void
	 */
	public static function get_transient_cache( $cache = null, $user_id = null, $is_transient = false ) {
		if ( null === $user_id ) {
			$user_id = wp_get_current_user()->ID;
		}
		$cache = str_replace( 'USERID', $user_id, $cache );

		/*
		 if ( false === $is_transient ) {
			if ( is_multisite() ) {
				return get_site_transient( $cache );
			} else {
				return get_transient( $cache );
			}
		} */

		if ( $is_transient ) {
			if ( is_multisite() ) {
				return get_site_transient( $cache );
			} else {
				return get_transient( $cache );
			}
		}
		if ( is_multisite() ) {
			return get_site_option( $cache, false );
		} else {
			return get_option( $cache, false );
		}
	}

	/**
	 * @param string $all
	 * @param null   $cache
	 * @param null   $user_id
	 */
	public static function remove_transient_cache( $all = 'no', $cache = null, $user_id = null ) {
		if ( null === $user_id ) {
			$user_id = wp_get_current_user()->ID;
		}

		if ( 'no' === $all ) {
			$cache = str_replace( 'USERID', $user_id, $cache );
			delete_option( $cache );
			delete_transient( $cache );
		} elseif ( 'yes' === $all ) {

		}
	}


	/**
	 * @param      $product
	 * @param bool    $initial
	 *
	 * @return float|string
	 */
	public static function get_custom_product_price( $product, $initial = false ) {

		if ( $product instanceof \WC_Product && $product->is_type( 'groups_plus_courses' ) ) {
			if ( 'yes' === (string) get_option( 'woocommerce_calc_taxes' ) ) {
				$price = 'yes' === get_option( 'woocommerce_prices_include_tax' ) ? wc_get_price_including_tax( $product ) : wc_get_price_excluding_tax( $product );
			} else {
				$price = $product->get_price();
			}
			\WoocommerceLicense::$product_price[ $product->get_id() ] = $price;

			return apply_filters( 'get_course_price', $price, $product );
		} elseif ( $product instanceof \WC_Product && $product->is_type( 'groups_plus_seats' ) ) {
			return self::get_license_price( $product, $initial );
		} else {
			return $product->get_price();
		}
	}

	/**
	 * Check if BuddyBoss is active
	 *
	 * @return bool
	 * @since 2.8.0
	 */
	public static function is_buddyboss_active() {
		include_once ABSPATH . 'wp-admin/includes/plugin.php';
		if ( is_plugin_active( 'buddyboss-platform/bp-loader.php' ) ) {
			return true;
		} elseif ( is_plugin_active_for_network( 'buddyboss-platform/bp-loader.php' ) ) {
			return true;
		} elseif ( class_exists( 'BuddyPress' ) ) {
			return true;
		} else {
			return false;
		}
	}

	public static function filter_has_var( $variable = null, $type = INPUT_GET ) {
		return filter_has_var( $type, $variable );
	}

	public static function filter_input( $variable = null, $type = INPUT_GET, $flags = FILTER_SANITIZE_STRING ) {
		return filter_input( $type, $variable, $flags );
	}

	public static function filter_input_array( $variable = null, $type = INPUT_GET, $flags = array() ) {
		if ( empty( $flags ) ) {
			$flags = array(
				'filter' => FILTER_VALIDATE_INT,
				'flags'  => FILTER_REQUIRE_ARRAY,
			);
		}
		/*
		 * View input types: https://www.php.net/manual/en/function.filter-input.php
		 * View flags at: https://www.php.net/manual/en/filter.filters.sanitize.php
		 */
		$args = array( $variable => $flags );
		$val  = filter_input_array( $type, $args );

		return isset( $val[ $variable ] ) ? $val[ $variable ] : array();
	}

	public static function get_template( $file_name ) {

		$template_path = 'learndash' . DIRECTORY_SEPARATOR . 'groups-plus' . DIRECTORY_SEPARATOR;
		$asset_path    = self::locate_template( $template_path . $file_name );

		if ( empty( $asset_path ) ) {
			$templates_directory = LEARNDASH_GROUPS_PLUS_DIR;

			$asset_path = $templates_directory . 'src/resources/' . $file_name;
		}

		return $asset_path;
	}

	public static function locate_template( $template_names ) {
		$located = '';
		foreach ( (array) $template_names as $template_name ) {
			if ( ! $template_name ) {
				continue;
			}
			if ( file_exists( get_stylesheet_directory() . DIRECTORY_SEPARATOR . $template_name ) ) {
				$located = get_stylesheet_directory() . DIRECTORY_SEPARATOR . $template_name;
				break;
			} elseif ( file_exists( get_template_directory() . DIRECTORY_SEPARATOR . $template_name ) ) {
				$located = get_template_directory() . DIRECTORY_SEPARATOR . $template_name;
				break;
			}
		}

		return $located;
	}

	/**
	 * Check if Gravity Form is active
	 *
	 * @return bool
	 * @since 2.8.0
	 */
	public static function is_gravity_form_active() {
		include_once ABSPATH . 'wp-admin/includes/plugin.php';
		if ( is_plugin_active( 'gravityforms/gravityforms.php' ) ) {
			return true;
		} elseif ( is_plugin_active_for_network( 'gravityforms/gravityforms.php' ) ) {
			return true;
		} else {
			return false;
		}
	}


	/**
	 * Check if
	 *
	 * @return bool
	 * @since 2.8.0
	 */
	public static function is_quiz_notification_for_ld_active() {
		include_once ABSPATH . 'wp-admin/includes/plugin.php';
		if ( is_plugin_active( 'elc-ldquiz-notifications/elc-ldquiz-notifications.php' ) ) {
			return true;
		} elseif ( is_plugin_active_for_network( 'woocommerce/woocommerce.php' ) ) {
			return true;
		} else {
			return false;
		}
	}
}

