<?php
namespace LearnDash\Groups_Plus\Module\BuddyBoss;

/**
 * Class Sync
 *
 * @package learndash_groups_plus
 */
class Sync {
	/**
	 * Sync constructor.
	 */
	public function __construct() {

		// when group is created
		add_action( 'init', array( $this, 'forced_logout' ), 1 );
		add_action( 'create_groups_plus', array( $this, 'child_group_created' ), 99, 2 );
		add_action( 'create_organization', array( $this, 'primary_group_created' ), 99, 2 );

		// for group leaders
		add_action( 'bb_add_group_leader', array( $this, 'group_leader_added' ), 20, 2 );
		add_action( 'bb_remove_group_leader', array( $this, 'group_leader_removed' ), 20, 2 );

		// for team members/users
		add_action( 'bb_add_user', array( $this, 'user_added_to_group' ), 20, 2 );
		add_action( 'bb_remove_user', array( $this, 'user_removed_from_group' ), 20, 2 );

		// for courses
		add_action( 'bb_add_course_to_group', array( $this, 'course_added_to_group' ), 20, 2 );
		add_action( 'bb_remove_course_to_group', array( $this, 'course_removed_from_group' ), 20, 2 );

	}

	/**
	 * @param $group_id
	 */
	public function primary_group_created( $group_id, $user_id ) {
		if ( 'yes' === get_option( 'enable_bb_organization', 'no' ) ) {
			$this->force_login( $user_id );
			add_filter( 'bp_loggedin_user_id', array( $this, 'loggedin_user_id' ), 99, 1 );
			do_action( 'bp_ld_sync/learndash_group_updated', $group_id );
		}
	}

	/**
	 * @param $group_id
	 */
	public function child_group_created( $group_id, $user_id ) {
		// hook to create buddyboss group
		if ( 'yes' === get_option( 'enable_bb_groups_plus', 'no' ) ) {
			$this->force_login( $user_id );
			add_filter( 'bp_loggedin_user_id', array( $this, 'loggedin_user_id' ), 99, 1 );
			do_action( 'bp_ld_sync/learndash_group_updated', $group_id );
		}
	}

	/**
	 * @param $user_id
	 * @param $group_id
	 */
	public function group_leader_added( $group_id, $user_id ) {
		do_action( 'bp_ld_sync/learndash_group_admin_added', $group_id, $user_id );
	}

	/**
	 * @param $user_id
	 * @param $group_id
	 */
	public function group_leader_removed( $group_id, $user_id ) {
		do_action( 'bp_ld_sync/learndash_group_admin_removed', $group_id, $user_id );
	}

	/**
	 * @param $user_id
	 * @param $group_id
	 */
	public function user_added_to_group( $group_id, $user_id ) {
		do_action( 'bp_ld_sync/learndash_group_user_added', $group_id, $user_id );
	}

	/**
	 * @param $user_id
	 * @param $group_id
	 */
	public function user_removed_from_group( $group_id, $user_id ) {
		do_action( 'bp_ld_sync/learndash_group_user_removed', $group_id, $user_id );
	}

	/**
	 * @param $course_id
	 * @param $group_id
	 */
	public function course_added_to_group( $group_id, $course_id ) {
		do_action( 'bp_ld_sync/learndash_group_course_added', $group_id, $course_id );
	}

	/**
	 * @param $course_id
	 * @param $group_id
	 */
	public function course_removed_from_group( $group_id, $course_id ) {
		do_action( 'bp_ld_sync/learndash_group_course_deleted', $group_id, $course_id );
	}

	private function force_login( $user_id ) {
		if ( ! is_user_logged_in() && $user_id ) {
			$user = get_user_by( 'id', $user_id );

			if ( $user ) {
				wp_set_current_user( $user_id, $user->user_login );
				wp_set_auth_cookie( $user_id );
				update_user_meta( $user_id, 'forced_login', 1 );
			}
		}
	}

	public function forced_logout() {
		if ( is_user_logged_in() ) {

			$user_id          = get_current_user_id();
			$uog_forced_login = get_user_meta( $user_id, 'forced_login', true );
			if ( $uog_forced_login ) {
				wp_logout();
				update_user_meta( $user_id, 'forced_login', 0 );
			}
		}
	}

	/**
	 * @param $user_id
	 */
	public function loggedin_user_id( $user_id ) {
		if ( ! $user_id ) {
			if ( is_user_logged_in() ) {
				$user_id = get_current_user_id();
			}
		}

		return $user_id;
	}
}
