<div class="wrap">
	<?php
	/**
	 * Site health render html.
	 *
	 * @package BuddyBossApp\HealthCheck
	 */

	use BuddyBossApp\Admin\Tools\HealthCheck;
	$test_groups = HealthCheck::instance()->get_tests();
	?>

	<div class="bbapp-health-check-body health-check-body hide-if-no-js">
		<div class="site-status-has-issues">
			<h2>
				<?php esc_html_e( 'Site Health Status', 'buddyboss-app' ); ?>
			</h2>

			<p><?php esc_html_e( 'The site health check shows critical information about your WordPress configuration and items that require your attention.', 'buddyboss-app' ); ?></p>

			<div class="health-check-title-section bbapp-site-health-progress-wrapper site-health-progress-wrapper loading hide-if-no-js">
				<div id="bbapp-site-health-progress" class="site-health-progress" data-pct="&nbsp;0">
					<svg role="img" aria-hidden="true" focusable="false" width="100%" height="100%" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
						<circle r="90" cx="100" cy="100" fill="transparent" stroke-dasharray="565.48" stroke-dashoffset="0"></circle>
						<circle id="bar" r="90" cx="100" cy="100" fill="transparent" stroke-dasharray="565.48" stroke-dashoffset="0"></circle>
					</svg>
				</div>
				<div class="site-health-progress-label">
					<?php esc_html_e( 'Results are still loading&hellip;', 'buddyboss-app' ); ?>
				</div>
			</div>

			<?php
			if ( ! empty( $test_groups ) ) {
				foreach ( $test_groups as $group ) {
					?>
					<div class="site-health-issues-wrapper" id="health-check-issues-<?php echo esc_html( $group['name'] ); ?>">
						<h3 class="site-health-issue-count-title">
							<?php echo esc_html( $group['label'] ); ?>
						</h3>
						<p><?php echo esc_html( $group['desc'] ); ?></p>
						<div id="health-check-site-status-<?php echo esc_html( $group['name'] ); ?>" class="health-check-accordion issues"></div>
					</div>
					<?php
				}
			}
			?>
		</div>
	</div>
	<script id="tmpl-health-check-issue" type="text/template">
		<h4 class="health-check-accordion-heading">
			<button aria-expanded="false" class="health-check-accordion-trigger" aria-controls="health-check-accordion-block-{{ data.test }}" type="button">
				<span class="title">{{ data.label }}</span>
				<span class="badge {{ data.badge.color }}">{{ data.badge.label }}</span>
				<span class="icon"></span>
			</button>
		</h4>
		<div id="health-check-accordion-block-{{ data.test }}" class="health-check-accordion-panel" hidden="hidden">
			<p>{{{ data.description }}}</p>
			<div class="actions">
				<p class="button-container">{{{ data.actions }}}</p>
			</div>
		</div>
	</script>
</div>
