<div class="wrap">
	<?php
	/**
	 * Site health info render html.
	 *
	 * @package BuddyBossApp\HealthCheck\WpDebugData
	 */

	use BuddyBossApp\HealthCheck\WpDebugData;
	?>
	<div class="health-check-body health-check-debug-tab hide-if-no-js">
		<?php

		WpDebugData::check_for_updates();

		$info = WpDebugData::debug_data();

		?>

		<h2>
			<?php esc_html_e( 'Site Health Info', 'buddyboss-app' ); ?>
		</h2>

		<p>
			<?php esc_html_e( 'The site health check shows critical information about your WordPress configuration. If you want to export all of the information on this page, you can use the button below to copy it to the clipboard. You can then paste it into an email exchange with a support agent or developer to help troubleshoot an issue.', 'buddyboss-app' ); ?>
		</p>

		<div class="site-health-copy-buttons">
			<div class="copy-button-wrapper">
				<button type="button" class="button copy-button" data-clipboard-text="<?php echo esc_attr( WpDebugData::format( $info, 'debug' ) ); ?>">
					<?php esc_html_e( 'Copy site info to clipboard', 'buddyboss-app' ); ?>
				</button>
				<span class="success hidden" aria-hidden="true"><?php esc_html_e( 'Copied!', 'buddyboss-app' ); ?></span>
			</div>
		</div>

		<div id="health-check-debug" class="health-check-accordion">

			<?php

			$sizes_fields = array( 'uploads_size', 'themes_size', 'plugins_size', 'wordpress_size', 'database_size', 'total_size' );

			foreach ( $info as $section => $details ) {
				if ( ! isset( $details['fields'] ) || empty( $details['fields'] ) ) {
					continue;
				}

				?>
				<h3 class="health-check-accordion-heading">
					<button aria-expanded="false" class="health-check-accordion-trigger" aria-controls="health-check-accordion-block-<?php echo esc_attr( $section ); ?>" type="button">
					<span class="title">
						<?php echo esc_html( $details['label'] ); ?>
						<?php

						if ( isset( $details['show_count'] ) && $details['show_count'] ) {
							printf( '(%d)', count( $details['fields'] ) );
						}

						?>
					</span>
						<?php
						if ( 'wp-paths-sizes' === $section ) {
							?>
							<span class="health-check-wp-paths-sizes spinner"></span>
							<?php
						}

						?>
						<span class="icon"></span>
					</button>
				</h3>

				<div id="health-check-accordion-block-<?php echo esc_attr( $section ); ?>" class="health-check-accordion-panel" hidden="hidden">
					<?php

					if ( isset( $details['description'] ) && ! empty( $details['description'] ) ) {
						printf( '<p>%s</p>', wp_kses_post( $details['description'] ) );
					}

					?>
					<table class="widefat striped health-check-table" role="presentation">
						<tbody>
						<?php

						foreach ( $details['fields'] as $field_name => $field ) {
							if ( is_array( $field['value'] ) ) {
								$values = '<ul>';

								foreach ( $field['value'] as $name => $value ) {
									$values .= sprintf( '<li>%s: %s</li>', esc_html( $name ), esc_html( $value ) );
								}

								$values .= '</ul>';
							} else {
								$values = esc_html( $field['value'] );
							}

							if ( in_array( $field_name, $sizes_fields, true ) ) {
								printf( '<tr><td>%s</td><td class="%s">%s</td></tr>', esc_html( $field['label'] ), esc_attr( $field_name ), wp_kses_post( $values ) );
							} else {
								$values = ! empty( $values ) ? wp_kses_post( $values ) : '&nbsp;';
								printf( '<tr><td>%s</td><td>%s</td></tr>', esc_html( $field['label'] ), $values );
							}
						}

						?>
						</tbody>
					</table>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
