<?php
/**
 * Holds log screen HTML.
 *
 * @package BuddyBossApp\Admin
 */

?>
<div class="wrap">
	<?php $this->show_messages(); ?>
	<?php
	$settings   = \BuddyBossApp\Tools\Logger::get_settings();
	$is_enabled = ! empty( $settings['logger_enabled'] );
	$log_list   = new \BuddyBossApp\Tools\Logger\LogList();
	$log_list->prepare_items();
	$log_categories = \BuddyBossApp\Tools\Logger::get_logger_types();
	?>

	<?php if ( $is_enabled ) { ?>
		<div id="bbapp-log-viewer">
			<div class="bbapp-log-filter">
				<?php
				$form_submiturl = bbapp_get_admin_url( 'admin.php?' );
				$log_filter_get = isset( $_GET['log_filter'] ) ? bbapp_input_clean( wp_unslash( $_GET['log_filter'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
				$page_get       = ! empty( $_GET['page'] ) ? bbapp_input_clean( wp_unslash( $_GET['page'] ) ) : 'bbapp-logs'; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
				$setting_get    = ! empty( $_GET['setting'] ) ? bbapp_input_clean( wp_unslash( $_GET['setting'] ) ) : 'log'; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
				?>
				<form method="get" action="<?php echo esc_url( $form_submiturl ); ?>">
					<input type="hidden" name="page" value="<?php echo esc_attr( $page_get ); ?>">
					<input type="hidden" name="setting" value="<?php echo esc_attr( $setting_get ); ?>">
					<select name="log_filter">
						<?php foreach ( $log_categories as $log_type_key => $log_type_label ) { ?>
							<option value="<?php echo esc_attr( $log_type_key ); ?>" 
								<?php
								if ( ! empty( $log_filter_get ) ) {
									selected( $log_filter_get, esc_attr( $log_type_key ) ); }
								?>
							>
								<?php echo esc_html( $log_type_label ); ?>
							</option>
						<?php } ?>
					</select>
					<button class="button" type="submit">Filter</button>
					<?php
					$nonce_url = wp_nonce_url(
						bbapp_get_super_admin_url(
							add_query_arg(
								array(
									'page'       => 'bbapp-tools',
									'setting'    => 'log',
									'log_filter' => $log_filter_get,
									'do_action'  => 'clear_log',
								),
								'admin.php'
							)
						),
						'bbapp-log-clear'
					)
					?>
					<a class="button" href="<?php echo esc_url( $nonce_url ); ?>">
						<?php esc_html_e( 'Clear Logs', 'buddyboss-app' ); ?>
					</a>
				</form>
			</div>
			<?php $log_list->display(); ?>
		</div>
	<?php } else { ?>
		<div class="buddyboss-app-admin-card">
			<h1><?php esc_html_e( 'Logs are disabled.', 'buddyboss-app' ); ?></h1>
			<p>
				<?php
				$log_admin_url = bbapp_get_admin_url( 'admin.php?page=bbapp-tools&setting=log&view=settings' );
				printf( '%1$s <a href="%2$s">%3$s</a> %4$s', esc_html__( 'You can', 'buddyboss-app' ), esc_url( $log_admin_url ), esc_html__( 'click here', 'buddyboss-app' ), esc_html__( 'to enable them in the Log Settings.', 'buddyboss-app' ) );
				?>
			</p>
		</div>
	<?php } ?>
</div>
