<?php
/**
 * Import Export view file.
 *
 * @package BuddyBossApp\Admin\Tools\ImportExport
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly.

/**
 * Manage app.
 *
 * @var $this \BuddyBossApp\Admin\ManageApp
 */
?>
<div class="bbapp-import-export">

	<?php if ( $this->get_current_sub_tab() === 'export' ) { ?>
	<div class="buddyboss-app-admin-card">
		<div class="bbapp-ie bbapp-import-export--export">
			<div class="bbapp-ie__heading">
				<div class="has_tutorial_link">
					<h2 class="title">
						<i class='bb-icon-bf bb-icon-download'></i>
						<?php echo esc_html__( 'Export', 'buddyboss-app' ); ?>
					</h2>
				</div>
				<p class="description">
					<?php echo esc_html__( 'When you click the button below, a ZIP file will be created for you to save to your computer. This file will contain your app settings as selected below. Once you’ve saved the downloaded file, you can use the Import function in another WordPress installation to import the app settings from this site. You can also use this as a backup before changing your app settings, which you can import to revert back to the previous settings.', 'buddyboss-app' ); ?>
				</p>
				<h3><?php echo esc_html__( 'Choose what to export', 'buddyboss-app' ); ?></h3>
			</div>
			<?php BuddyBossApp\Admin\Tools\ImportExport::instance()->load_all_import_export_modules(); ?>
			<form method="POST" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" id="bbapp_export">
				<input type="hidden" name="action" value="bbapp_export"/>
				<?php wp_nonce_field( 'bbapp_export', 'nonce' ); ?>
				<div class="bbapp-ie__block">
					<?php foreach ( BuddyBossApp\Admin\Tools\ImportExport::instance()->get_modules() as $module ) { ?>
						<div class="bbapp-ie__row">
							<label>
								<input checked="checked" type="checkbox" name="export_modules[]" value="<?php echo esc_attr( $module ); ?>"/>
								<?php echo wp_kses_post( BuddyBossApp\Admin\Tools\ImportExport::instance()->get_module_label( $module ) ); ?>
							</label>
						</div>
					<?php } ?>
				</div>
				<div class="bbapp-ie__footer">
					<div class="bbapp-export-button">
						<button type="submit" name="submit" class="button-primary bbapp-export-btn">
							<?php echo esc_attr__( 'Download Export File', 'buddyboss-app' ); ?>
						</button>
					</div>
				</div>
			</form>
		</div>
	</div>
	<?php } ?>

	<?php if ( $this->get_current_sub_tab() === 'import' ) { ?>
	<div class="buddyboss-app-admin-card">
		<div class="bbapp-import-export--import bbapp-ie">
			<div class="bbapp-ie__heading">
				<div class="has_tutorial_link">
					<h2 class="title">
						<i class='bb-icon-bf bb-icon-upload'></i>
						<?php echo esc_html__( 'Import', 'buddyboss-app' ); ?>
					</h2>
				</div>
				<p class="description">
					<?php echo esc_html__( 'Choose a ZIP file to upload, then click Upload file and import.', 'buddyboss-app' ); ?>
				</p>
			</div>

			<div class="bbapp-ie__block">
				<?php BuddyBossApp\Admin\Tools\ImportExport::instance()->load_all_import_export_modules(); ?>
				<form method="POST" id="bbapp_import">
					<input type="hidden" name="action" value="bbapp_import"/>
					<?php wp_nonce_field( 'bbapp_import', 'nonce' ); ?>
					<!--Load import modules.-->
					<div class="import-modules"></div>

					<br />

					<a href="javascript:void(0);" class="button-primary bbapp-import-btn">
						<div class="bbapp_loading" style="display:none;vertical-align: middle;margin-bottom:10px"></div>
						<?php echo esc_attr__( 'Upload file and import', 'buddyboss-app' ); ?>
						<input type="file" id="bbapp_import_file" name="bbapp_import" value="<?php echo esc_attr__( 'Import', 'buddyboss-app' ); ?>">
					</a>
				</form>
			</div>
		</div>
	</div>
	<?php } ?>

</div>

<script>
	jQuery( document ).ready( function() {
		// Disable export button when no export checkbox selected.
		jQuery( '.export-modules' ).find( 'input' ).change( function() {
			jQuery( '.bbapp-export-btn' ).prop( 'disabled', ! ( jQuery( '.export-modules' ).find( 'input:checked' ).length > 0 ) );
		} );

		/* Zip file read. */
		jQuery( document ).on( 'change', '#bbapp_import_file', function() {
			const $this = jQuery( this );
			const fileData = jQuery( this ).prop( 'files' )[ 0 ];
			const formData = new FormData();
			formData.append( 'bbapp_import_file', fileData );
			formData.append( 'action', 'bbapp_import_file_upload' );
			jQuery( '.import-modules' ).html( '<div class="bbapp_loading" style="vertical-align: middle;"></div>' );
			const post = jQuery.ajax( {
				url: ajaxurl,
				type: 'POST',
				contentType: false,
				processData: false,
				data: formData,
			} );
			post.done( function( data ) {
				if ( data.data.message ) {
					// eslint-disable-next-line no-alert
					alert( data.data.message );
					$this.val( '' );
				} else if ( true === data.success ) {
					jQuery( '.import-modules' ).html( data.data.html );
				}
			} );
			post.always( function() {
				jQuery( '.bbapp-import-btn' ).hide();
			} );
		} );

		jQuery( document ).on( 'click', '.bbapp-import-btn-final', function() {
			jQuery( '#bbapp_import' ).submit();
		} );

		jQuery( document ).on( 'click', '.bbapp-import-back', function( e ) {
			e.preventDefault();
			jQuery( jQuery( '#bbapp_import' ) ).find( '.bbapp_loading' ).hide();
			jQuery( '.import-modules' ).html( '' );
			jQuery( '.bbapp-import-btn' ).show();
			jQuery( '#bbapp_import_file' ).val( '' );
		} );

		jQuery( '#bbapp_import' ).submit( function( e ) {
			e.preventDefault();
			const form = this;
			jQuery( form ).find( '.bbapp_loading' ).show();
			jQuery( '.bbapp-import-back' ).hide();
			const formData = new FormData( form );

			const post = jQuery.ajax( {
				url: ajaxurl + '?action=bbapp_import',
				type: 'POST',
				dataType: 'json',
				data: formData,
				cache: false,
				processData: false,
				contentType: false,
			} );

			post.done( function( data ) {
				// eslint-disable-next-line no-alert
				alert( data.data.message );
			} );

			post.always( function() {
				jQuery( form ).find( '.bbapp_loading' ).hide();
				jQuery( '.import-modules' ).html( '' );
				jQuery( '.bbapp-import-btn' ).show();
				jQuery( '#bbapp_import_file' ).val( '' );
				jQuery( '.bbapp-import-back' ).show();
			} );
		} );
	} );
</script>
