<?php
/**
 * Holds Google key store generate HTML.
 *
 * @package BuddyBossApp\Admin
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<?php if ( isset( $_GET['success'] ) && true === (bool) $_GET['success'] ) { //phpcs:ignore WordPress.Security.NonceVerification.Recommended ?>
	<div id="setting-error-settings_updated" class="notice notice-success settings-error is-dismissible">
		<p>
			<strong> <?php echo esc_html__( 'Your KeyStore certificate has been downloaded successfully.', 'buddyboss-app' ); ?></strong>
		</p>
	</div>
<?php } ?>
<div class="bbapp-generate-keystore">
	<div class="buddyboss-app-admin-card">
		<div class="bbapp-ie">
			<div class="bbapp-ie__heading">
				<h2 class="title generate_keystore_title">
					<i class='bb-icon-bf bb-icon-key'></i>
					<?php echo esc_html__( 'Generate KeyStore', 'buddyboss-app' ); ?>
				</h2>
				<div class="bbapp-keystore-intro">
					<p>
						<?php echo esc_html__( 'To create Android builds, Google requires all developers authenticate their apps with a KeyStore to confirms their identity.', 'buddyboss-app' ); ?>
					</p>
					<p>
						<?php printf( '%1$s <a href="%2$s">%3$s</a> %4$s', esc_html__( 'Use the tool below to generate a KeyStore information on our servers. After the KeyStore is generated, you will be able to download a compressed folder which can be imported on the', 'buddyboss-app' ), esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-configure&setting=android' ) ), esc_html__( 'Android Settings', 'buddyboss-app' ), esc_html__( 'page.', 'buddyboss-app' ) ); ?>
					</p>
				</div>
			</div>
		</div>
		<div class="bbapp_generate_keystore_wrapper">
			<div class="bbapp-ie__block">
				<div id="generate-keystore-msgs" class="generate-keystore-msgs">

				</div>
			</div>
			<div class="bbapp_generate_keystore_form_wrapper">
				<form method="POST" action="" id="bbapp_generate_keystore">
					<?php wp_nonce_field( 'bbapp_generate_keystore', 'keystore_nonce' ); ?>
					<div class="bbapp-keystore-generate-form">
						<table class="form-table">
							<tbody>
							<tr class="bbapp_field_wrapper configure-subheadline">
								<td class="bbapp-form-html" scope="row" colspan="2">
									<h4 class="title"><?php echo esc_html__( 'KeyStore Information', 'buddyboss-app' ); ?></h4>
								</td>
							</tr>
							<tr>
								<th scope="row">
									<label for="bbapp_key_store_password">
										<?php esc_html_e( 'KeyStore Password', 'buddyboss-app' ); ?>
									</label>
								</th>
								<td class="bbapp_field_wrapper">
									<div class="bbapp-password bbapp-app-key">
										<div class="bbapp-password__block">
											<input type="password" name="password" value="" id="bbapp_key_store_password" class="bbapp_password_field regular-text" required/>
											<button type="button"
													class="button button-secondary bbapp-hide-pw hide-if-no-js"
													data-toggle="0"
													aria-label="<?php esc_html_e( 'Show password', 'buddyboss-app' ); ?>">
												<span class="bb-icon-l bb-icon-eye" aria-hidden="true"></span>
											</button>
										</div>
									</div>
									<p class="description"><?php echo esc_html__( 'Enter a password for your KeyStore. If you leave this blank, a password will be generated for you.', 'buddyboss-app' ); ?></p>
								</td>
							</tr>
							<tr>
								<th scope="row">
									<label for="bbapp_key_alias">
										<?php esc_html_e( 'KeyStore Alias', 'buddyboss-app' ); ?>
									</label>
								</th>
								<td>
									<input type="text" name="alias" value="" id="bbapp_key_alias" class="regular-text" required/>
									<p class="description"><?php echo esc_html__( 'Enter an alias for your KeyStore. If you leave this blank, an alias will be generated for you.', 'buddyboss-app' ); ?></p>
								</td>
							</tr>
							<tr class="bbapp_field_wrapper configure-subheadline">
								<td class="bbapp-form-html" scope="row" colspan="2">
									<h4 class="title"><?php echo esc_html__( 'Certificate Information', 'buddyboss-app' ); ?></h4>
									<p>
										<?php printf( '%1$s <strong>%2$s</strong> %3$s', esc_html__( 'Enter the information of the individual or organization to be entered into this certificate. Fields in', 'buddyboss-app' ), esc_html__( 'bold', 'buddyboss-app' ), esc_html__( 'are required.', 'buddyboss-app' ) ); ?>
									</p>
								</td>
							</tr>
							<tr>
								<th scope="row">
									<label for="bbapp_first_last_name">
										<?php esc_html_e( 'First and Last Name', 'buddyboss-app' ); ?>
									</label>
								</th>
								<td>
									<input type="text" name="fl_name" id="bbapp_first_last_name" class="regular-text" required/>
								</td>
							</tr>
							<tr>
								<th scope="row">
									<label for="bbapp_organization" class="bbapp-text-regular">
										<?php esc_html_e( 'Organization', 'buddyboss-app' ); ?>
									</label>
								</th>
								<td>
									<input type="text" name="organization" class="regular-text" id="bbapp_organization"/>
								</td>
							</tr>
							<tr>
								<th scope="row">
									<label for="bbapp_organization_unit" class="bbapp-text-regular">
										<?php esc_html_e( 'Organization Unit', 'buddyboss-app' ); ?>
									</label>
								</th>
								<td>
									<input type="text" name="organization_unit" class="regular-text" id="bbapp_organization_unit"/>
								</td>
							</tr>
							<tr>
								<th scope="row">
									<label for="bbapp_city_or_locality" class="bbapp-text-regular">
										<?php esc_html_e( 'City or Locality', 'buddyboss-app' ); ?>
									</label>
								</th>
								<td>
									<input type="text" name="city" id="bbapp_city_or_locality" class="regular-text"/>
								</td>
							</tr>
							<tr>
								<th scope="row">
									<label for="bbapp_state_or_province" class="bbapp-text-regular">
										<?php esc_html_e( 'State or Province', 'buddyboss-app' ); ?>
									</label>
								</th>
								<td>
									<input type="text" name="state" id="bbapp_state_or_province" class="regular-text"/>
								</td>
							</tr>
							<tr>
								<th scope="row">
									<label for="bbapp_country_code" class="bbapp-text-regular">
										<?php esc_html_e( 'Country Code (XX)', 'buddyboss-app' ); ?>
									</label>
								</th>
								<td>
									<input type="text" name="country_code" id="bbapp_country_code" class="regular-text"/>
								</td>
							</tr>
							</tbody>
						</table>
					</div>
					<div class="bbapp-keystore-generate-button">
						<table>
							<tbody>
							<tr>
								<th colspan="2">
									<button type="submit"
											class="button-primary keystore-generate-secondary-btn sbmt-btn">
										<span><?php esc_html_e( 'Generate', 'buddyboss-app' ); ?></span>
										<div class="bbapp_loading dark" style="display:none"></div>
									</button>
								</th>
							</tr>
							</tbody>
						</table>
					</div>
					<div class="bbapp-keystore-download-form hidden">
						<div class="bbapp-ie">
							<div class="bbapp-ie__heading">
								<p>
									<?php printf( '<strong>%1$s</strong>', esc_html__( 'Important - Please Read Before Downloading', 'buddyboss-app' ) ); ?>
								</p>
								<p>
									<?php
									esc_html_e( 'You must download and backup your KeyStore after downloading. You will not be able to download it again. If you lose your KeyStore, you will not be able to publish new versions of your Android app to the Google Play Store.', 'buddyboss-app' );
									?>
								</p>
							</div>
						</div>
						<table class="form-table">
							<tbody>
							<tr class="bbapp_field_wrapper configure-subheadline">
								<td class="bbapp-form-html" scope="row" colspan="2">
									<input id="bbapp_keystore_understand" class="regular-text keystore_understand" name="keystore_understand" type="checkbox" value="1"/>
									<label for="bbapp_keystore_understand"><?php echo esc_html__( 'I understand I will not be able to download this KeyStore certificate again', 'buddyboss-app' ); ?></label>
								</td>
							</tr>
							<tr>
								<th colspan="2">
									<input type="hidden" name="keystore_zip">
									<input type="hidden" name="keystore_zip_name">
									<button type="submit" disabled id="donwload_button"
											class="button-primary keystore-generate-secondary-download-btn sbmt-btn"
											disabled>
										<?php esc_html_e( 'Download', 'buddyboss-app' ); ?>
										<div class="bbapp_loading dark" style="display:none"></div>
									</button>
								</th>
							</tr>
							</tbody>
						</table>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
<?php
$generate_keystore_link = bbapp_get_admin_url(
	add_query_arg(
		array(
			'page'    => 'bbapp-tools',
			'setting' => 'generate-keystore',
			'success' => 1,
		),
		'admin.php'
	)
);

?>
<script>
	jQuery( document ).ready( function() {
		const _understand = jQuery( '#bbapp_keystore_understand' );
		const _keystoreMsgs = jQuery( '#generate-keystore-msgs' );

		jQuery( document ).on( 'click', '.keystore-generate-secondary-btn', function( e ) {
			e.preventDefault();
			const _this = jQuery( this );
			_this.prop( 'disabled', true );
			const loader = _this.find( '.bbapp_loading' );
			loader.css( 'display', 'inline-block' );
			let _return = true;
			let _returnError = '<?php esc_html_e( 'The following fields are required to generate a KeyStore certificate:', 'buddyboss-app' ); ?>';
			if ( jQuery( '#bbapp_key_store_password' ).val() === '' ) {
				jQuery( '#bbapp_key_store_password' ).val( '<?php echo esc_html( bbapp_generate_password( 10, false ) ); ?>' );
			}
			if ( jQuery( '#bbapp_key_alias' ).val() === '' ) {
				jQuery( '#bbapp_key_alias' ).val( 'App' );
			}

			if ( jQuery( '#bbapp_first_last_name' ).val() === '' ) {
				_returnError += '<?php printf( '<p class="bbapp-keystore-err-list">%1$s</p>', esc_html__( 'First and Last name is required to generate KeyStore.', 'buddyboss-app' ) ); ?>';
				_return = false;
			}
			if ( true === _return ) {
				_keystoreMsgs.addClass( 'keystore-err' ).html( '' );
				jQuery( '.bbapp-keystore-generate-form' ).hide();
				bbappGenerateKeystore( _this );
			} else {
				_keystoreMsgs.addClass( 'keystore-err' ).html( '<div class="bbapp-notice-box bbapp-notice-box--error">' + _returnError + '</div>' );
				_this.prop( 'disabled', false );
				loader.css( 'display', 'none' );
			}
		} );

		jQuery( document ).on( 'click', '.keystore-generate-secondary-download-btn', function( e ) {
			e.preventDefault();
			_keystoreMsgs.html( '' );
			const _termsCheck = jQuery( '#bbapp_generate_keystore' ).find( '#bbapp_keystore_understand' );
			if ( _termsCheck.prop( 'checked' ) !== true ) {
				_keystoreMsgs.addClass( 'keystore-err' );
				_keystoreMsgs.html( '<div class="bbapp-notice-box bbapp-notice-box--error"><?php esc_html_e( 'Sorry the you have not selected checkbox.', 'buddyboss-app' ); ?></div>' );
				return false;
			}
			const loader = jQuery( this );
			loader.prop( 'disabled', true );
			loader.find( '.bbapp_loading' ).css( 'display', 'inline-block' );
			const formEl = jQuery( '#bbapp_generate_keystore' );
			const _zipName = formEl.find( 'input[name="keystore_zip_name"]' ).val();
			const _zipUrl = formEl.find( 'input[name="keystore_zip"]' ).val();
			if ( _zipUrl && _zipName ) {
				const link = document.createElement( 'a' );
				link.setAttribute( 'download', _zipName );
				link.href = _zipUrl;
				document.body.appendChild( link );
				link.click();
				link.remove();
				setTimeout( function() {
					window.location = '<?php echo $generate_keystore_link; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>';
				}, 1000 );
			}
			loader.prop( 'disabled', false );
			loader.find( '.bbapp_loading' ).css( 'display', 'none' );
		} );

		_understand.on( 'change', function() {
			jQuery( '#bbapp_generate_keystore' ).find( '#donwload_button' ).attr( 'disabled', ! jQuery( this ).prop( 'checked' ) );
		} );
	} );

	function bbappGenerateKeystore( buttonEl ) {
		buttonEl.find( 'span' ).text( '<?php esc_html_e( 'Generating...', 'buddyboss-app' ); ?>' );
		const formEl = jQuery( '#bbapp_generate_keystore' );
		const _keystoreMsgs = jQuery( '#generate-keystore-msgs' );
		const _successform = jQuery( '.bbapp-keystore-download-form' );

		const data = {
			action: 'bpapp_download_keystore',
		};

		jQuery.each( formEl.serializeArray(), function( _, kv ) {
			data[ kv.name ] = kv.value;
		} );

		jQuery.post( ajaxurl, data, function( response ) {
			if ( true === response.success ) {
				jQuery( '.bbapp-keystore-generate-button' ).hide();
				jQuery( '.bbapp-keystore-intro' ).hide();
				_successform.prepend( '<div class="bbapp-notice-box bbapp-notice-box--success"><?php esc_html_e( 'Your Keystore certificate was successfully generated.', 'buddyboss-app' ); ?></div>' );
				_successform.show();
				formEl.find( 'input[name="keystore_zip"]' ).val( response.data.url );
				formEl.find( 'input[name="keystore_zip_name"]' ).val( response.data.name );
			} else {
				_keystoreMsgs.addClass( 'keystore-err' ).html( response.data.message );
				jQuery( '.bbapp-keystore-generate-form' ).show();
				jQuery( '.bbapp-keystore-download-form' ).hide();
			}
			buttonEl.find( 'span' ).text( '<?php esc_html_e( 'Generated', 'buddyboss-app' ); ?>' );
			buttonEl.prop( 'disabled', false );
			buttonEl.find( '.bbapp_loading' ).css( 'display', 'none' );
		} );
	}
</script>
