<?php
/**
 * Holds html for transients
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed direct

/**
 * \BuddyBossApp\Admin\Debug
 *
 * @var $status_helper
 */
$status_helper = $this;

// Enqueue some required scripts.
wp_enqueue_style( 'bbapp-tipsy' );
wp_enqueue_script( 'bbapp-tipsy' );
?>

<div class="wrap">    
	<?php $status_helper->show_messages(); ?>

	<form id="debug_tools" method="post" enctype="multipart/form-data">
		<?php
		wp_nonce_field( 'bbapp_update_settings_debug_tools', 'bbapp_update_settings_debug_tools' );
		?>
		<table class="bboc_status_table widefat" cellspacing="0" id="status">
			<thead>
			<tr>
				<th colspan="3" data-export-label="Transients"><h2><?php esc_html_e( 'Transients', 'buddyboss-app' ); ?></h2></th>
			</tr>
			</thead>
			<tbody>
			<tr class="entry-row alternate">
				<td width="30%"><?php esc_html_e( 'App Transients:', 'buddyboss-app' ); ?></td>
				<td class="help" style="vertical-align: middle; ">
					<span class="dashicons dashicons-editor-help abtip" title="<?php esc_html_e( 'This will clear all cache & transients made by BuddyBoss App plugin.', 'buddyboss-app' ); ?>"></span>
				</td>
				<td>
					<button class="button" type="submit" name="clear_transients"><?php esc_html_e( 'Clear Transients', 'buddyboss-app' ); ?></button>
				</td>
			</tr>
			<tr>
				<td><?php esc_html_e( 'Device Tokens:', 'buddyboss-app' ); ?></td>
				<td class="help" style="vertical-align:middle; ">
					<span class="dashicons dashicons-editor-help abtip" title="<?php esc_html_e( 'This will clear all duplicate device tokens in database if any. Please make sure to take a backup before performing this.', 'buddyboss-app' ); ?>"></span>
				</td>
				<td>
					<button class="button" type="submit" name="clear_duplicates_device_tokens"><?php esc_html_e( 'Clear Duplicates', 'buddyboss-app' ); ?></button>
				</td>
			</tr>
			<tr>
				<td><?php esc_html_e( 'All Device Tokens:', 'buddyboss-app' ); ?></td>
				<td class="help" style="vertical-align:middle; ">
					<span class="dashicons dashicons-editor-help abtip" title="<?php esc_html_e( 'This will clear all device tokens in database if any. Please make sure to take a backup before performing this.', 'buddyboss-app' ); ?>"></span>
				</td>
				<td>
					<button class="button" type="submit" name="clear_all_device_tokens"><?php esc_html_e( 'Clear All', 'buddyboss-app' ); ?></button>
				</td>
			</tr>
			</tbody>
		</table>

	</form>

</div>

<script>
	jQuery( document ).ready( function() {
		jQuery( '.abtip' ).tipsy( { fade: true, gravity: 's' } );
	} );
</script>
