<?php
/**
 * Publish - terms of service
 *
 * @package BuddyBossApp\Publish
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="bbapp-publish-terms-block buddyboss-app-admin-card">
	<h2 class="buddyboss-app-admin-card__blank-banner"><?php esc_html_e( 'Terms of Service', 'buddyboss-app' ); ?></h2>
	<form action="<?php echo esc_url( bbapp_get_admin_url( 'admin.php' ) ); ?>" method="get">
		<?php echo wp_kses_post( \BuddyBossApp\Publish::instance()->get_publish_term_condition() ); ?>
		<input type="hidden" name="page" value="bbapp-publish"/>
		<label for="agree">
			<input type="checkbox" value="1" name="agree-publish-term" id="agree" required/>
			<?php esc_html_e( 'I agree to the BuddyBoss Terms of Service', 'buddyboss-app' ); ?>
		</label>
		<div class="submit">
			<input type="submit" class="button button-primary terms-agree-btn" value="<?php esc_attr_e( 'Confirm', 'buddyboss-app' ); ?>" disabled/>
		</div>
	</form>
</div>
<script>
	function enableAcceptTermButton() {
		if ( jQuery( 'input[name="agree-publish-term"]' ).prop( 'checked' ) ) {
			jQuery( '.terms-agree-btn' ).prop( 'disabled', false );
		} else {
			jQuery( '.terms-agree-btn' ).prop( 'disabled', true );
		}
	}

	jQuery( document ).ready( function() {
		enableAcceptTermButton();

		jQuery( 'input[name="agree-publish-term"]' ).change( function() {
			enableAcceptTermButton();
		} );
	} );
</script>
