<?php
/**
 * Publish - Status
 *
 * @package BuddyBossApp\Publish
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use BuddyBossApp\Publish as OuterPublish;

$platform = ! empty( $_GET['setting'] ) ? bbapp_input_clean( wp_unslash( $_GET['setting'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

$platform_label = array(
	'ios'     => 'iOS',
	'android' => 'Android',
);
if ( empty( $platform ) ) {
	echo '<div class="bbapp-publish-block"><p class="bbapp-error">' . esc_html__( 'Some required information has not been configured. Please go back end try again.', 'buddyboss-app' ) . '</p></div>';

	return;
}

$publish_option = OuterPublish::instance()->get_publish_options();
$publish_option = ( isset( $publish_option['publish_requested'] ) ? $publish_option['publish_requested'] : array() );
$error_key      = ( isset( $publish_option[ $platform ]['key'] ) ? $publish_option[ $platform ]['key'] : '' );
$error_label    = ( ! empty( $error_key ) ? \BuddyBossApp\Admin\Publish\Publish::instance()->publish_error_key_label( $error_key ) : '' );
$settings_get   = ! empty( $_GET['setting'] ) ? bbapp_input_clean( wp_unslash( $_GET['setting'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$platform_type  = ( 'android' === $settings_get ) ? 'android' : 'ios';
?>

<div class="bbapp-publish-block bbapp-publish-block--card ios">
	<div>
		<h2 class="bbapp-publish-block__ios-heading">
			<?php
			if ( 'android' === $platform_type ) {
				esc_html_e( 'Publish Your Android App', 'buddyboss-app' );
			} else {
				esc_html_e( 'Publish Your iOS App', 'buddyboss-app' );
			}
			?>
			<a class="button button-secondary bbapp-tutorial-btn" href="https://www.buddyboss.com/resources/?p=124544" target="_blank">
				<?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?>
			</a>
		</h2>
		<?php
		if ( ! isset( $publish_option[ $platform ] ) ) {
			echo '<div class="bbapp-publish-error-block">';
			echo sprintf( '%1$s %2$s. &nbsp;<a href="%3$s">%4$s</a>', esc_html__( 'You currently have no publish in progress for', 'buddyboss-app' ), esc_html( $platform_label[ $platform ] ), esc_url( bbapp_get_super_admin_url( 'admin.php?page=bbapp-publish' ) ), esc_html__( 'View publish history.', 'buddyboss-app' ) );
			echo '</div>';
		} else {
			?>
			<div class="bbapp-publish-error-block">
				<p class="bbapp-notice-box bbapp-notice-box--error">
					<?php
					$error_label = ( ! empty( $error_label ) && ! is_array( $error_label ) ? $error_label : $publish_option[ $platform ]['error_message'] );
					echo sprintf( '<strong>%1$s</strong><br/><em>%2$s</em>', esc_html__( 'There was a problem creating your publish request:', 'buddyboss-app' ), esc_html( $error_label ) );
					?>
				</p>
				<p><?php esc_html_e( 'If you are unable to resolve the issue listed above, please contact BuddyBoss support.', 'buddyboss-app' ); ?></p>
			</div>
		<?php } ?>
	</div>
</div>
