<?php
/**
 * Holds publish select HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
use BuddyBossApp\ManageApp;

/**
 * Publish class variable.
 *
 * @var $this BuddyBossApp\Admin\Publish\Publish
 */
?>

<div class="bbapp-publish-block ios text-center">
	<div class="icon-wrap">
		<svg width="74" height="74" xmlns="http://www.w3.org/2000/svg"><g fill="none" fill-rule="evenodd"><circle fill="#F6F6F6" cx="37" cy="37" r="37"/><path d="M38.656 19.307C41.236 16.016 44.821 16 44.821 16s.533 3.094-2.03 6.074c-2.735 3.183-5.844 2.662-5.844 2.662s-.584-2.503 1.71-5.43zm-1.381 7.596c1.326 0 3.789-1.765 6.994-1.765 5.517 0 7.688 3.8 7.688 3.8s-4.245 2.101-4.245 7.2c0 5.751 5.288 7.733 5.288 7.733s-3.697 10.073-8.69 10.073c-2.293 0-4.076-1.496-6.493-1.496-2.462 0-4.906 1.552-6.497 1.552C26.76 54 21 44.445 21 36.764c0-7.556 4.876-11.52 9.449-11.52 2.973 0 5.28 1.66 6.826 1.66z" fill="#1C1D1E" fill-rule="nonzero"/></g></svg>
	</div>
	<h2 class="title"><?php esc_attr_e( 'Request iOS Publish', 'buddyboss-app' ); ?></h2>
	<p><?php esc_attr_e( 'Request a new publish to be generated for your iOS app.', 'buddyboss-app' ); ?></p>

	<div class="buttons-wrap">
		<a href="<?php echo esc_attr( $this->get_link( 'step=review&app_platform=ios' ) ); ?>" class="bbapp-pub-btn dev">
			<svg width="16" height="16" xmlns="http://www.w3.org/2000/svg"><path d="M12 0a4 4 0 014 4v8a4 4 0 01-4 4H4a4 4 0 01-4-4V4a4 4 0 014-4h8zM9.136 4.27c-.358-.085-.688.112-.801.474-.22.697-.436 1.395-.655 2.092L6.645 10.14l-.237.756c-.104.337.124.756.456.835.358.084.688-.113.8-.475.22-.697.437-1.395.656-2.092L9.355 5.86l.236-.756c.107-.337-.123-.756-.455-.835zM5.579 5.463c-.26-.249-.661-.27-.92 0L2.934 7.266l-.247.258c-.25.258-.25.699 0 .96.577.599 1.152 1.199 1.727 1.798l.248.258c.24.252.68.27.92 0 .238-.269.258-.69 0-.96a339.852 339.852 0 00-1.517-1.577c.425-.44.842-.88 1.265-1.321l.25-.258c.24-.252.258-.71 0-.96zm5.761-.002c-.24-.251-.681-.27-.92 0s-.258.69 0 .96l1.515 1.581c-.42.442-.847.88-1.268 1.32l-.247.258c-.24.251-.258.71 0 .96.258.248.662.269.92 0l1.727-1.802.247-.258a.713.713 0 000-.96L11.587 5.72l-.247-.258z" fill="#333" fill-rule="evenodd"/></svg>
			<span><?php esc_attr_e( 'Publish', 'buddyboss-app' ); ?></span>
		</a>
	</div>
</div>

<div class="bbapp-publish-block android text-center">
	<div class="icon-wrap">
		<svg width="74" height="74" xmlns="http://www.w3.org/2000/svg"><g fill="none" fill-rule="evenodd"><circle fill="#F6F6F6" cx="37" cy="37" r="37"/><path d="M47.975 28.849l.008.135.003.138v15.415c0 1.599-1.187 2.898-2.693 2.989l-.169.005-.113-.001v6.098c0 1.31-1.032 2.372-2.307 2.372-1.274 0-2.307-1.062-2.307-2.372V47.53h-5.795v6.098c0 1.31-1.032 2.372-2.306 2.372s-2.307-1.062-2.307-2.372l-.001-6.098h-.113c-1.528 0-2.77-1.241-2.856-2.816l-.005-.177V29.122l.004-.138.01-.135h20.947zM23.307 30.22c1.274 0 2.307 1.062 2.307 2.372v10.174c0 1.31-1.033 2.372-2.307 2.372S21 44.077 21 42.767V32.593c0-1.31 1.033-2.372 2.307-2.372zm28.386 0c1.274 0 2.307 1.062 2.307 2.372v10.174c0 1.31-1.033 2.372-2.307 2.372s-2.307-1.062-2.307-2.372V32.593c0-1.31 1.033-2.372 2.307-2.372zm-4.47-12.187a.254.254 0 01.096.328l-.007.013-1.953 3.48c1.56 1.605 2.514 3.694 2.545 5.981H27.096c.03-2.287.985-4.376 2.545-5.982l-1.953-3.48a.254.254 0 01.089-.34.239.239 0 01.316.067l.008.011.008.013 1.896 3.374c1.64-1.523 3.856-2.546 6.335-2.792h2.32c2.479.246 4.695 1.27 6.336 2.793l1.895-3.375a.24.24 0 01.332-.091zm-14.02 4.357c-.659.002-1.191.54-1.19 1.202a1.198 1.198 0 001.197 1.201 1.196 1.196 0 001.19-1.201 1.197 1.197 0 00-1.196-1.202zm8.91 0c-.659.002-1.191.54-1.19 1.202a1.198 1.198 0 001.197 1.201 1.196 1.196 0 001.19-1.201 1.197 1.197 0 00-1.196-1.202z" fill="#97C13D" fill-rule="nonzero"/></g></svg>
	</div>
	<h2 class="title"><?php esc_attr_e( 'Request Android Publish', 'buddyboss-app' ); ?></h2>
	<p><?php esc_attr_e( 'Request a new publish to be generated for your Android app.', 'buddyboss-app' ); ?></p>

	<div class="buttons-wrap">
		<a href="<?php echo esc_attr( $this->get_link( 'step=review&app_platform=android' ) ); ?>" class="bbapp-pub-btn dev">
			<svg width="16" height="16" xmlns="http://www.w3.org/2000/svg"><path d="M12 0a4 4 0 014 4v8a4 4 0 01-4 4H4a4 4 0 01-4-4V4a4 4 0 014-4h8zM9.136 4.27c-.358-.085-.688.112-.801.474-.22.697-.436 1.395-.655 2.092L6.645 10.14l-.237.756c-.104.337.124.756.456.835.358.084.688-.113.8-.475.22-.697.437-1.395.656-2.092L9.355 5.86l.236-.756c.107-.337-.123-.756-.455-.835zM5.579 5.463c-.26-.249-.661-.27-.92 0L2.934 7.266l-.247.258c-.25.258-.25.699 0 .96.577.599 1.152 1.199 1.727 1.798l.248.258c.24.252.68.27.92 0 .238-.269.258-.69 0-.96a339.852 339.852 0 00-1.517-1.577c.425-.44.842-.88 1.265-1.321l.25-.258c.24-.252.258-.71 0-.96zm5.761-.002c-.24-.251-.681-.27-.92 0s-.258.69 0 .96l1.515 1.581c-.42.442-.847.88-1.268 1.32l-.247.258c-.24.251-.258.71 0 .96.258.248.662.269.92 0l1.727-1.802.247-.258a.713.713 0 000-.96L11.587 5.72l-.247-.258z" fill="#333" fill-rule="evenodd"/></svg>
			<span><?php esc_attr_e( 'Publish', 'buddyboss-app' ); ?></span>
		</a>
	</div>
</div>
