<?php
/**
 * Holds publish scope review HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use BuddyBossApp\Publish;

/**
 * Publish class variable.
 *
 * @var $this BuddyBossApp\Admin\Publish\Publish
 */

$app_platform_get    = ( ! empty( $_GET['app_platform'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['app_platform'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$review_information  = $this->get_review_information();
$review_info_summary = $this->get_review_info_summary( $review_information );
$build               = Publish::instance();
$app_version         = $build->get_app_version( $app_platform_get );
$app_version_code    = $build->get_app_version_code( $app_platform_get );

if ( ! empty( $review_info_summary['invalid'] ) ) {
	echo sprintf( '<p class="bbapp-error">%1$s <span>%2$s</span> %3$s</p>', esc_html__( 'Some required information has not been configured. Click the pencil icon for each', 'buddyboss-app' ), esc_html__( 'incomplete', 'buddyboss-app' ), esc_html__( 'section and return here once finished.', 'buddyboss-app' ) );
}
?>

<div class="bbapp-publish-review-info bb-publish-review-info">
	<?php if ( empty( $review_information ) ) { ?>
		<p><?php esc_html_e( 'No Review Information found', 'buddyboss-app' ); ?></p>
	<?php } else { ?>
		<ul class="bbapp-cards">
			<?php
			foreach ( $review_information as $rinfo_name => $rinfo ) {
				if ( 'files' === $rinfo_name ) {
					continue;
				}
				?>

				<li class="bbapp-card <?php echo esc_attr( 'bbapp-info-' . ( ( $rinfo['validated'] ) ? 'valid' : 'invalid' ) ); ?>">
					<div class="bbapp-card-inner">
						<header class="bbapp-card-header">
							<h3 class="bbapp-card-title"><?php echo esc_attr( $rinfo['label'] ); ?></h3>
							<a class="bbapp-edit bb-edit" href="<?php echo esc_url( $rinfo['edit_link'] ); ?>">
								<svg width="10" height="10" xmlns="http://www.w3.org/2000/svg">
									<path d="M5.837 2.036L7.98 4.18 2.993 9.166l-2.481.339.338-2.482 4.987-4.987zM7.054.82a.991.991 0 011.402 0l.742.742.001.001a.991.991 0 01-.002 1.402l-.686.685-2.143-2.143z" fill="#3171A6" fill-rule="nonzero"/>
								</svg>
							</a>
						</header>
						<?php
						if ( empty( $rinfo['value'] ) ) {
							$rinfo['value'] = __( 'N/A', 'buddyboss-app' );
						}

						if ( isset( $rinfo['validated'] ) && $rinfo['validated'] ) {
							if ( isset( $rinfo['is_multi_image'] ) && is_array( $rinfo['value'] ) ) {
								foreach ( $rinfo['value'] as $rid ) {
									echo '<img src="' . esc_url( wp_get_attachment_url( $rid ) ) . '" class="bbapp-image-preview" />  ';
								}
							} elseif ( isset( $rinfo['is_image'] ) ) {
								echo '<img src="' . esc_url( $rinfo['value'] ) . '" class="bbapp-image-preview" />';
							} elseif ( isset( $rinfo['preview'] ) ) {
								echo wp_kses_post( $rinfo['preview'] );
							} else {
								echo esc_html( $rinfo['value'] );
							}
						} else {
							echo sprintf( '<div class="bb-card-content"><span class="bbapp-invalid-val">%1$s</span> %2$s</div>', esc_html( $rinfo['label'] ), esc_html__( 'needs to be configured.', 'buddyboss-app' ) );
						}
						?>
					</div>
				</li>
			<?php } ?>
		</ul>
		<?php
	}

	if ( empty( $review_info_summary['invalid'] ) ) {
		$app_env_get = ( ! empty( $_GET['app_env'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['app_env'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		?>
		<form target="_self" method="post" id="bbapp_publish">
			<div class="bb-build-request-form">
				<div class="bb-col bb-app-submit">
					<?php $this->publish_nonce_field(); ?>
					<input type="hidden" name="action" value="bbapp_publish_request_submit"/>
					<input type="hidden" name="app_env" value="<?php echo esc_attr( $app_env_get ); ?>"/>
					<input type="hidden" name="app_platform" value="<?php echo esc_attr( $app_platform_get ); ?>"/>
					<button class="button button-primary bbapp-submit-btn" type="submit">
						<div class="bbapp_loading light" style="display:none"></div>
						<span><?php esc_html_e('Send Publish Request', 'buddyboss-app'); ?></span><span class="bb-arrow-wrap"><svg width="6" height="10" xmlns="http://www.w3.org/2000/svg"><path d="M1 1l4 4-4 4" stroke="#FFF" stroke-width="1.5" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round"/></svg></span></button>
					</div>
				</div>
			</form>
			<script>
				jQuery( document ).ready( function() {
					jQuery( '#bbapp_publish' ).submit( function( e ) {
						e.preventDefault();
						jQuery( '.bbapp-submit-btn' ).prop( 'disabled', true ).find( '.dashicons' ).hide().parent().find( '.bbapp_loading' ).show();

					const post = jQuery.post( ajaxurl, jQuery( this ).serialize() );

						post.always( function() {
							jQuery( '.bbapp-submit-btn' ).prop( 'disabled', false ).find( '.dashicons' ).show().parent().find( '.bbapp_loading' ).hide();
						} );
						post.done( function( data ) {
							if ( ! data.success ) {
								// eslint-disable-next-line no-alert
								alert( data.data );
								return false;
							}
							window.location.href = data.data.redirect;
						} );
						post.fail( function() {
							// eslint-disable-next-line no-alert
							alert( '<?php esc_html_e( 'Network Error. Please try again.', 'buddyboss-app' ); ?>' );
						} );
					} );
				} );
		</script>
		<?php
	}
	?>
</div>
