<?php
/**
 * Publish - iOS
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Publish clas variable.
 *
 * @var $this BuddyBossApp\Admin\Publish\Publish
 */

use BuddyBossApp\Build;
use BuddyBossApp\AppStores\Apple;

$action_get = ( isset( $_GET['action'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['action'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

if ( 'create' === $action_get && 'status' === $this->get_current_step() ) {
	include dirname( __FILE__ ) . '/publish-status.php';
} elseif ( Apple::instance()->is_connected() ) {
	$app_package_id = \BuddyBossApp\AppSettings::instance()->get_setting_value( 'publish.ios.namespace' );
	$has_build_id   = Apple::instance()->has_client_app_bundle_id( $app_package_id, true );

	if ( empty( $app_package_id ) ) {
		?>
		<div class="bbapp-publish-block bbapp-publish-block--card ios">
			<h2 class="bbapp-publish-block__ios-heading">
				<?php esc_html_e( 'Configure Your Bundle ID', 'buddyboss-app' ); ?>
			</h2>
			<div class="data-update-ajax">
				<p>
					<?php
					printf( '%1$s <a href="%2$s">%3$s</a> %4$s', esc_html__( 'To continue, please select your Release App\'s Bundle ID in the App Configuration section of the', 'buddyboss-app' ), esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-configure&setting=ios#app_settings_app_publish_ios_live_settings' ) ), esc_html__( 'iOS Settings', 'buddyboss-app' ), esc_html__( 'page.', 'buddyboss-app' ) );
					?>
				</p>
				<a href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-configure&setting=ios' ) ); ?>" class="button button-primary">
					<?php esc_html_e( 'Configure Now', 'buddyboss-app' ); ?>
				</a>
				<a href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-help&article=122248' ) ); ?>" class="button button-secondary" target="_blank">
					<?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?>
				</a>
			</div>
		</div>
		<?php
	} elseif ( ! $has_build_id ) {
		?>
		<div class="bbapp-publish-block bbapp-publish-block--card ios">
			<h3 class="bbapp-publish-block__ios-heading">
				<?php esc_html_e( 'Assign Your Bundle ID To An App', 'buddyboss-app' ); ?>
			</h3>
			<div class="data-update-ajax">
				<p>
					<?php printf( '%1$s <a href="%2$s">%3$s</a> %4$s (%5$s)', esc_html__( 'To continue, please create an app in', 'buddyboss-app' ), esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-configure&setting=ios#app_settings_app_publish_ios_live_settings' ) ), esc_html__( 'App Store Connect', 'buddyboss-app' ), esc_html__( 'and assign to it your Release App Bundle ID', 'buddyboss-app' ), esc_html( $app_package_id ) ); ?>
				</p>
				<button type="button" class="button button-primary refresh-bundle-id">
					<div class="bbapp_loading" style="display:none;"></div>
					<?php esc_html_e( 'Check Again', 'buddyboss-app' ); ?>
				</button>
				<a href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-help&article=122248' ) ); ?>" class="button button-secondary" target="_blank">
					<?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?>
				</a>
			</div>
		</div>
		<script>
			jQuery( document ).ready( function() {
				jQuery( '.refresh-bundle-id' ).click( function( e ) {
					e.preventDefault();
					const target = jQuery( this );

					target.prop( 'disabled', true ).find( '.bbapp_loading' ).show();

					const post = jQuery.post( ajaxurl, {
						action: 'bbapp_refresh_bundle_id',
					} );

					post.always( function() {
						target.prop( 'disabled', false ).find( '.bbapp_loading' ).hide();
					} );
					post.done( function() {
						location.reload();
					} );
					post.fail( function() {
						// eslint-disable-next-line no-alert
						alert( "<?php esc_html_e( 'Network Error. Please try again.', 'buddyboss-app' ); ?>" );
					} );
				} );
			} );
		</script>
		<?php
	} else {
		\BuddyBossApp\Publish::instance()->check_publish_status();
		$publish_option  = \BuddyBossApp\Publish::instance()->get_publish_options();
		$publish_history = BuddyBossApp\Admin\Publish\Publish::instance()->get_publish_history( 'ios' );
		$publish_history = ( ! empty( $publish_history ) && ! is_wp_error( $publish_history ) && ! empty( $publish_history['data'] ) ) ? array_column( $publish_history['data'], 'status', 'id' ) : array();

		global $publish_ios_id;

		$publish_ios_id = '';

		if ( ! empty( $publish_option ) && ! empty( $publish_option['publish_requested'] ) && ! empty( $publish_option['publish_requested']['ios'] ) && ! empty( $publish_option['publish_requested']['ios']['publish_id'] ) && ! empty( $publish_option['publish_requested']['ios']['publish_status'] ) && ! in_array( $publish_option['publish_requested']['ios']['publish_status'], array( 'cancelled' ), true ) ) {
			$publish_ios_id  = $publish_option['publish_requested']['ios']['publish_id'];
			$publish_details = \BuddyBossApp\Admin\Publish\Publish::instance()->get_publish_details( $publish_ios_id );

			if ( empty( $publish_details ) ) {
				require dirname( __FILE__ ) . '/publish-ios-app.php';
			} else {
				require dirname( __FILE__ ) . '/publish-ios-detail.php';
			}
		} elseif ( ! empty( $publish_history ) && 'cancelled' !== current( $publish_history ) && ! empty( array_key_first( $publish_history ) ) ) {
			$publish_ios_id  = array_key_first( $publish_history );
			$publish_details = \BuddyBossApp\Admin\Publish\Publish::instance()->get_publish_details( $publish_ios_id );

			if ( empty( $publish_details ) ) {
				require dirname( __FILE__ ) . '/publish-ios-app.php';
			} else {
				require dirname( __FILE__ ) . '/publish-ios-detail.php';
			}
		} else {
			require dirname( __FILE__ ) . '/publish-ios-app.php';
		}
	}
} else {
	?>
	<div class="bbapp-publish-block bbapp-publish-block--card ios">
		<h2 class="bbapp-publish-block__ios-heading">
			<i class="bb-icon-f bb-icon-brand-apple"></i>
			<?php esc_html_e( 'Connect Your Apple Developer Account', 'buddyboss-app' ); ?>
		</h2>
		<div class="data-update-ajax">
			<p>
				<?php esc_html_e( 'You must connect your Apple Developer Account to publish iOS builds through the BuddyBoss Publishing Service.', 'buddyboss-app' ); ?>
			</p>
			<a href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-configure&setting=ios' ) ); ?>" class="button button-primary">
				<?php esc_html_e( 'Connect Now', 'buddyboss-app' ); ?>
			</a>
			<a href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-help&article=122274' ) ); ?>" class="button button-secondary" target="_blank">
				<?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?>
			</a>
		</div>
	</div>
	<?php
}
