<?php
/**
 * Publish - iOS Version.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


$display_app_data = \BuddyBossApp\AppStores\Apple::instance()->display_app_data();
$validate         = array_column( $display_app_data, 'validate' );
$has_error        = ! empty( $display_app_data ) && count( $validate ) > count( array_filter( $validate ) );
$app_package_id   = \BuddyBossApp\AppStores\Apple::instance()->get_release_bundle_id();
$app_id           = \BuddyBossApp\AppStores\Apple::instance()->get_apple_release_bundle_store_app_id();

if ( $has_error ) {
	?>
	<div class="top-content">
		<p><?php esc_html_e( 'Before you can submit your app for review, you must fully prepare a version inside of App Store Connect.', 'buddyboss-app' ); ?></p>
		<p><?php esc_html_e( 'Please enter the information specified below in App Store Connect and then click Save.', 'buddyboss-app' ); ?></p>
		<p><?php esc_html_e( 'Once saved, click the Check Again button below.', 'buddyboss-app' ); ?></p>

		<div class="buttons">
			<a href="<?php echo esc_url( "https://appstoreconnect.apple.com/apps/{$app_id}/appstore" ); ?>" target="_blank" class="button button-secondary">
				<?php esc_html_e( 'Edit in App Store Connect', 'buddyboss-app' ); ?>
			</a>
			<button type="button" class="button button-primary check-again">
				<span class="bbapp_loading" style="display:none;"></span>
				<?php esc_html_e( 'Check Again', 'buddyboss-app' ); ?>
			</button>
		</div>
	</div>
	<?php
} else {
	?>
	<div class="top-content">
		<p><?php esc_html_e( 'The BuddyBoss Publishing Service will upload your build to App Store Connect and attach it to the version specified below.', 'buddyboss-app' ); ?></p>
		<p><?php esc_html_e( 'Please confirm that the version information below is correct and ready for review.', 'buddyboss-app' ); ?></p>
		<div class="buttons">
			<input type="hidden" name="version" value="confirmed"/>
			<input type="hidden" name="tab" value="review"/>
			<a href="<?php echo esc_url( "https://appstoreconnect.apple.com/apps/{$app_id}/appstore" ); ?>" target="_blank" class="button button-secondary">
				<?php esc_html_e( 'Edit in App Store Connect', 'buddyboss-app' ); ?>
			</a>
			<button type="submit" class="button button-primary confirm-version">
				<div class="bbapp_loading dark" style="display:none"></div>
				<?php esc_html_e( 'Confirm Version', 'buddyboss-app' ); ?>
			</button>
		</div>
	</div>
	<?php
}

if ( ! empty( $display_app_data ) ) {
	?>
	<div class="display-app-data">
		<p>
			<?php
			if ( array_key_exists( 'app_title', $display_app_data ) ) {
				printf( '<strong>%1$s %2$s</strong>', esc_html( $display_app_data['app_title']['label'] ), esc_html( $display_app_data['app_title']['value'] ) );
				unset( $display_app_data['app_title'] );
			}
			if ( array_key_exists( 'app_status', $display_app_data ) ) {
				echo ' ' . wp_kses_post( $display_app_data['app_status']['value'] );
				unset( $display_app_data['app_status'] );
			}
			?>
		</p>
		<?php if ( empty( $has_error ) ) { ?>
			<button type="button" class="button button-secondary display-btn-right check-again">
				<span class="bbapp_loading" style="display:none;"></span>
				<?php esc_html_e( 'Refresh Data', 'buddyboss-app' ); ?>
			</button>
		<?php } ?>
	</div>
	<?php
	echo '<table width="100%" class="form-table">';
	foreach ( $display_app_data as $key => $data ) {
		if ( ! empty( $data['type'] ) && 'headline' === $data['type'] ) {
			echo '<tr class="bbapp-card"><th colspan="2" class="header-row"><h4 class="bbapp-card-title">' . ( ! empty( $data['label'] ) ? esc_html( $data['label'] ) : '' ) . '</h4></th></tr>';
		} else {
			?>
			<tr class="bbapp-card">
				<th>
                    <?php echo( ! empty( $data['label'] ) ? esc_html( $data['label'] ) : '' ); ?>
                    <?php
                    if( ! empty( $data['required'] ) ) {
                        echo '<span class="bbapp-required bbapp-error-msg">*</span>';
                    }
                    ?>
                </th>
				<td>
					<?php
					// Handle the screenshots dynamically based on app_screenshot_list()
					$app_screenshot_keys = \BuddyBossApp\AppStores\Apple::instance()->app_screenshot_list();
					if ( empty( $data['validate'] ) && ! empty( $data['error'] ) ) {
						echo '<p class="bbapp-notice-box bbapp-notice-box--warning">' . wp_kses_post( $data['error'] ) . '</p>';
					} elseif ( array_key_exists( strtolower( $key ), $app_screenshot_keys ) && ! empty( $data['value'] ) ) {
						foreach ( $data['value'] as $image ) {
							echo '<div class="image-box bb-card-content"><a class="bbapp-fancy bbapp-fancy--img" data-fancybox="gallery" href="' . esc_url( $image ) . '"><img src="' . esc_url( $image ) . '" alt="" /></a></div>';
						}
					} elseif ( ! empty( $data['value'] ) ) {
						echo '<p>' . wp_kses_post( $data['value'] ) . '</p>';
					} else {
						echo '<p>' . esc_html__( 'N/A', 'buddyboss-app' ) . '</p>';
					}
					?>
				</td>
			</tr>
			<?php
		}
	}
	echo '</table>';
}
?>
<script>
	jQuery( document ).ready( function() {
		jQuery( '.check-again' ).click( function( e ) {
			e.preventDefault();
			const target = jQuery( this );

			target.prop( 'disabled', true ).find( '.bbapp_loading' ).show();

			const post = jQuery.post( ajaxurl, {
				action: 'bbapp_refresh_app_data',
			} );
			post.done( function() {
				location.reload();
			} );
			post.fail( function() {
				target.prop( 'disabled', false ).find( '.bbapp_loading' ).hide();
				// eslint-disable-next-line no-alert
				alert( "<?php esc_html_e( 'Network Error. Please try again.', 'buddyboss-app' ); ?>" );
			} );
		} );

		jQuery( 'button.button.confirm-version' ).click( function() {
			jQuery( this ).find( '.bbapp_loading' ).show();
			jQuery( this ).addClass( 'btn-disabled' );
		} );
	} );
</script>
