<?php
/**
 * Publish - iOS Details
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $publish_ios_id;

if ( empty( $publish_ios_id ) ) {
	echo '<p class="bbapp-notice-box bbapp-notice-box--error">' . esc_html__( 'Some required information has not been configured. Please go back end try again.', 'buddyboss-app' ) . '</p>';

	return;
}

$publish_detail   = \BuddyBossApp\Admin\Publish\Publish::instance()->get_publish_details( $publish_ios_id );
$display_app_data = \BuddyBossApp\AppStores\Apple::instance()->display_app_data();
$app_package_id   = \BuddyBossApp\AppStores\Apple::instance()->get_release_bundle_id();
$app_id           = \BuddyBossApp\AppStores\Apple::instance()->get_apple_release_bundle_store_app_id();
$publish_detail   = ! empty( $publish_detail ) && ! is_wp_error( $publish_detail ) ? $publish_detail : array();
$build_id         = ! empty( $publish_detail ) && ! is_wp_error( $publish_detail ) && isset( $publish_detail['build_id'] ) ? $publish_detail['build_id'] : 0;
$publish_id       = ! empty( $publish_detail ) && ! is_wp_error( $publish_detail ) && isset( $publish_detail['id'] ) ? $publish_detail['id'] : 0;

if ( isset( $publish_detail['status'] ) && in_array( $publish_detail['status'], array( 'completed' ), true ) ) {
	require dirname( __FILE__ ) . '/publish-ios-app-completed.php';

	return;
} elseif ( isset( $publish_detail['status'] ) && in_array( $publish_detail['status'], array( 'customer_completed' ), true ) ) {
	require dirname( __FILE__ ) . '/publish-ios-app-customer-completed.php';

	return;
}

$disabled_button = false;
?>
<div class="bbapp-publish-block bbapp-publish-block--card ios">
	<div>
		<h2 class="bbapp-publish-block__ios-heading bbapp-publish-block__headline">
			<i class="bb-icon-bf bb-icon-brand-apple"></i>
			<?php esc_html_e( 'Publish Your iOS App', 'buddyboss-app' ); ?>
			<?php echo wp_kses_post( \BuddyBossApp\Admin\Publish\Publish::instance()->publish_status_text( $publish_detail['status'] ) ); ?>
			<a class="button button-secondary bbapp-tutorial-btn" href="https://www.buddyboss.com/resources/?p=124544" target="_blank">
				<?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?>
			</a>
		</h2>
		<div class="publish-information">
			<div class="bbapp-publish-block__finale flex">
				<div class="info-tile">
					<h4><?php esc_html_e( 'Request ID', 'buddyboss-app' ); ?></h4>
					<p><?php echo '#' . esc_html( $publish_ios_id ); ?></p>
				</div>
				<div class="info-tile">
					<h4><?php esc_html_e( 'Current Stage', 'buddyboss-app' ); ?></h4>
					<p><?php echo isset( $publish_detail['get_publishing_current_phase'] ) ? wp_kses_post( $publish_detail['get_publishing_current_phase'] ) : ''; ?></p>
				</div>
				<div class="info-tile">
					<h4><?php esc_html_e( 'Last Update', 'buddyboss-app' ); ?></h4>
					<p><?php echo isset( $publish_detail['modified_time'] ) ? esc_html( get_gmt_from_date( gmdate( 'Y-m-d H:i:s', $publish_detail['modified_time'] ), get_option( 'date_format' ) . ' ' . get_option( 'time_format' ) ) ) : ''; ?></p>
				</div>
				<div class="info-tile align-right info-tile--ctrl">
					<?php
					if (
						isset( $publish_detail['status'] ) &&
						! in_array(
							$publish_detail['status'],
							array(
								'changes_required',
								'completed',
								'customer_completed',
								'cancelled',
								'connection_lost',
							),
							true
						)
					) {
						?>
						<a href="javascript:void();" class="button button-secondary refresh-status" data-id="<?php echo esc_attr( $publish_ios_id ); ?>">
							<span class="bbapp_loading" style="display:none;"></span>
							<?php esc_html_e( 'Recheck Status', 'buddyboss-app' ); ?>
						</a>
						<?php
					}
					$allowed_html                 = wp_kses_allowed_html( 'post' );
					$allowed_html['a']['data-id'] = true;
					$allowed_html['div']['style'] = true;
					echo wp_kses( \BuddyBossApp\Admin\Publish\Publish::instance()->publish_action_url( $publish_detail['status'], $publish_ios_id ), $allowed_html );
					?>
				</div>
			</div>
			<?php
			if ( isset( $publish_detail['status'] ) && ! in_array(
				$publish_detail['status'],
				array(
					'changes_required',
					'completed',
					'customer_completed',
					'cancelled',
					'connection_lost',
				),
				true
			) ) {
				?>
				<div class="bbapp-publish-block__finale flex">
					<div class="info-tile">
						<h4><?php esc_html_e( 'Do you want BuddyBoss to respond to Apple?', 'buddyboss-app' ); ?></h4>
						<p><?php echo isset( $publish_detail['data']['review_information']['respond_to_request'] ) ? ( ! empty( $publish_detail['data']['review_information']['respond_to_request'] ) ? 'Yes' : 'No' ) : 'No'; ?></p>
					</div>
				</div>
				<?php
			}

			if ( ! empty( $display_app_data ) ) {
				if ( isset( $publish_detail['status'] ) && ! in_array( $publish_detail['status'], array( 'changes_required' ), true ) ) {
					?>
					<div class="display-app-data">
						<p>
							<?php
							if ( array_key_exists( 'app_title', $display_app_data ) ) {
								printf( '<strong>%1$s %2$s</strong>', esc_html( $display_app_data['app_title']['label'] ), esc_html( $display_app_data['app_title']['value'] ) );
								unset( $display_app_data['app_title'] );
							}

							if ( array_key_exists( 'app_status', $display_app_data ) ) {
								echo ' ' . esc_html( $display_app_data['app_status']['value'] );
								unset( $display_app_data['app_status'] );
							}
							?>
						</p>
						<?php
						$key            = '_site_transient_timeout_bbapp_apple_app_fetched_data_' . $app_id;
						$transient_time = get_site_option( $key );

						if ( empty( $transient_time ) ) {
							$transient_time = get_option( $key );
						}

						if ( ! empty( $transient_time ) ) {
							$fetched_time = strtotime( '-1 day', $transient_time );
						} else {
							$fetched_time = time();
						}
						?>
						<span class="display-app-data__sync"><?php echo esc_html__( 'Last synced ', 'buddyboss-app' ) . esc_html( get_gmt_from_date( gmdate( 'Y-m-d H:i:s', $fetched_time ), get_option( 'date_format' ) . ' ' . get_option( 'time_format' ) ) ); ?></span>
					</div>
					<?php
					echo '<table width="100%" class="form-table">';

					foreach ( $display_app_data as $key => $data ) {
						if ( ! empty( $data['type'] ) && 'headline' === $data['type'] ) {
							echo '<tr class="bbapp-card"><th colspan="2" class="header-row"><h4 class="bbapp-card-title">' . ( ! empty( $data['label'] ) ? esc_html( $data['label'] ) : '' ) . '</h4></th></tr>';
						} else {
							?>
							<tr class="bbapp-card">
								<th><?php echo( ! empty( $data['label'] ) ? esc_html( $data['label'] ) : '' ); ?></th>
								<td>
									<?php
									// Handle the screenshots dynamically based on app_screenshot_list()
									$app_screenshot_keys = \BuddyBossApp\AppStores\Apple::instance()->app_screenshot_list();
									if ( empty( $data['validate'] ) && ! empty( $data['error'] ) ) {
										echo '<p class="bbapp-notice-box bbapp-notice-box--warning">' . wp_kses_post( $data['error'] ) . '</p>';
									} elseif ( array_key_exists( strtolower( $key ), $app_screenshot_keys ) && ! empty( $data['value'] ) ) {
										foreach ( $data['value'] as $image ) {
											echo '<div class="image-box bb-card-content"><a class="bbapp-fancy bbapp-fancy--img" data-fancybox="gallery" href="' . esc_url( $image ) . '"><img src="' . esc_url( $image ) . '" alt="" /></a></div>';
										}
									} elseif ( ! empty( $data['value'] ) ) {
										echo '<p>' . wp_kses_post( $data['value'] ) . '</p>';
									} else {
										echo '<p>' . esc_html__( 'N/A', 'buddyboss-app' ) . '</p>';
									}
									?>
								</td>
							</tr>
							<?php
						}
					}
					echo '</table>';
				} elseif ( isset( $publish_detail['status'] ) && 'changes_required' === $publish_detail['status'] ) {
					$builds = \BuddyBossApp\Build::instance()->get_app_builds( 'ios', 'live', false, 'completed', '1', '12', true );
					?>
					<div class="bbapp-publish-block__finale">
						<h4 class="changes-recommended-heading"><?php esc_html_e( 'Changes Recommended by BuddyBoss', 'buddyboss-app' ); ?></h4>
						<div class="flex">
							<div class="changes-left-box">
								<div class="changes-recommended">
									<?php echo( isset( $publish_detail['changes_requested_content'] ) ? wp_kses_post( $publish_detail['changes_requested_content'] ) : '' ); ?>
								</div>
							</div>
							<div class="changes-right-box">
								<form id="publish-app-form" method="post">
									<h4><?php esc_html_e( 'Have you made the recommended changes?', 'buddyboss-app' ); ?></h4>
									<div class="field-wrap">
										<label>
											<input type="radio" name="made-changes" value="yes" checked>
											<span><?php esc_html_e( 'Yes, please review the changes', 'buddyboss-app' ); ?></span>
										</label>
										<label>
											<input type="radio" name="made-changes" value="no">
											<span><?php esc_html_e( 'No, please submit to Apple with the current information', 'buddyboss-app' ); ?></span>
										</label>
									</div>

									<?php
									if ( ! empty( $builds['data'] ) && ! is_wp_error( $builds ) && count( $builds['data'] ) > 1 ) {
										$disabled_button = true;
										?>
										<h4><?php esc_html_e( 'Do you want to change the build version?', 'buddyboss-app' ); ?></h4>
										<div class="field-wrap">
											<label>
												<input type="radio" name="build-change" value="no" checked>
												<span><?php esc_html_e( 'No', 'buddyboss-app' ); ?></span>
											</label>
											<label>
												<input type="radio" name="build-change" value="yes">
												<span><?php esc_html_e( 'Yes', 'buddyboss-app' ); ?></span>
												<div class="build-select">
													<select class="build-version-select" name="build-select">
														<?php
														if ( ! empty( $builds['data'] ) && ! is_wp_error( $builds ) ) {
															?>
															<option value=""><?php esc_html_e( '--Select Build--', 'buddyboss-app' ); ?></option>
															<?php
															foreach ( $builds['data'] as $b_id => $build ) {
																?>
																<option value="<?php echo esc_attr( $build['id'] ); ?>" <?php echo ( $build['id'] === $build_id ) ? 'disabled' : ''; ?>>
																	<?php printf( '%1$s #%2$s %3$s(%4$s)', esc_html__( 'Build', 'buddyboss-app' ), esc_html( $build['id'] ), esc_html( $build['build_version'] ), esc_html( $build['build_version_code'] ) ); ?>
																</option>
																<?php
															}
														}
														?>
													</select>
													<input type="hidden" name="build-id-updated" value="<?php echo esc_attr( $build_id ); ?>">
													<input type="hidden" name="build-id" value="<?php echo esc_attr( $build_id ); ?>">
												</div>
											</label>
										</div>
									<?php } else { ?>
										<input type="hidden" name="build-id-updated" value="<?php echo esc_attr( $build_id ); ?>">
										<input type="hidden" name="build-id" value="<?php echo esc_attr( $build_id ); ?>">
									<?php } ?>

									<p class="submit">
										<input type="hidden" name="create-publish-nonce" id="create-publish-nonce" value="<?php echo esc_attr( wp_create_nonce( 'create-publish-nonce' ) ); ?>"/>
										<input type="hidden" name="action" value="bbapp_publish_app"/>
										<input type="hidden" name="platform" value="ios"/>
										<input type="hidden" name="publish_id" value="<?php echo esc_attr( $publish_id ); ?>"/>
										<button type="submit"
												class="button button-primary update-publish-app" <?php echo( true === $disabled_button ? 'disabled' : '' ); ?>>
											<span class="bbapp_loading" style="display:none;"></span>
											<?php esc_html_e( 'Submit Response', 'buddyboss-app' ); ?>
										</button>
									</p>
								</form>
							</div>
						</div>
					</div>
					<?php
				}
			}
			?>
		</div>
	</div>
</div>
<script>
	<?php if ( true === $disabled_button ) { ?>
	function buildChange() {
		const buildChangeChecked = jQuery( 'input[name="build-change"]:checked' ).val();
		const buildDelect = jQuery( 'select[name="build-select"]' ).val();

			if ( buildChangeChecked === 'yes' && buildDelect === '' ) {
				jQuery( '.update-publish-app' ).prop( 'disabled', true );
			} else if ( ( buildChangeChecked === 'yes' && buildDelect !== '' ) || buildChangeChecked === 'no' ) {
				jQuery( '.update-publish-app' ).prop( 'disabled', false );
			}
		}
	<?php } ?>
		jQuery( document ).ready( function() {
			<?php if ( true === $disabled_button ) { ?>
			buildChange();

			jQuery( 'input[name="build-change"]' ).on( 'change', function () {
				buildChange();
			} );
			<?php } ?>

			jQuery( '.refresh-status' ).click( function( e ) {
				e.preventDefault();
				const target     = jQuery( this );
				const publishID = jQuery( this ).attr( 'data-id' );

				target.prop( 'disabled', true ).find( '.bbapp_loading' ).show();

				const postRefresh = jQuery.post( ajaxurl, {
					action: 'bbapp_publish_status_actions',
					publish_id: publishID,
					sub_action: 'status_check',
					platform: 'ios',
					bbapp_publish_actions: '<?php echo esc_attr( wp_create_nonce( 'bbapp_publish_actions', 'bbapp_publish_actions' ) ); ?>',
				} );

				postRefresh.done( function() {
					location.reload();
				} );

				postRefresh.fail( function() {
					target.prop( 'disabled', false ).find( '.bbapp_loading' ).hide();
					// eslint-disable-next-line no-alert
					alert( "<?php esc_html_e( 'Network Error. Please try again.', 'buddyboss-app' ); ?>" );
				} );
			} );

			jQuery( '.cancle-request' ).click( function( e ) {
				e.preventDefault();

				// eslint-disable-next-line no-alert
				if ( ! confirm( '<?php esc_html_e( 'Are you sure you want to cancel this publish request?', 'buddyboss-app' ); ?>' ) ) {
					return false;
				}

				jQuery( this ).find( '.bbapp_loading' ).show();
				jQuery( this ).addClass( 'btn-disabled' );

				const target     = jQuery( this );
				const publishID = jQuery( this ).attr( 'data-id' );

				target.prop( 'disabled', true ).find( '.bbapp_loading' ).show();

				const post = jQuery.post( ajaxurl, {
					action: 'bbapp_publish_status_actions',
					publish_id: publishID,
					sub_action: 'cancel',
					platform: 'ios',
					bbapp_publish_actions: '<?php echo esc_attr( wp_create_nonce( 'bbapp_publish_actions', 'bbapp_publish_actions' ) ); ?>',
				} );

				post.done( function() {
					location.reload();
				} );

				post.fail( function() {
					target.prop( 'disabled', false ).find( '.bbapp_loading' ).hide();
					// eslint-disable-next-line no-alert
					alert( "<?php esc_html_e( 'Network Error. Please try again.', 'buddyboss-app' ); ?>" );
				} );
			} );

			jQuery( '#publish-app-form' ).submit( function( e ) {
				e.preventDefault();

				jQuery( '.update-publish-app' ).prop( 'disabled', true ).find( '.bbapp_loading' ).show();

				const post = jQuery.ajax( {
					type: 'POST',
					url: ajaxurl,
					data: new FormData( this ),
					dataType: 'json',
					contentType: false,
					cache: false,
					processData: false,
				} );

				post.always( function() {
					jQuery( '.update-publish-app' ).prop( 'disabled', false ).find( '.bbapp_loading' ).hide();
				} );

				post.done( function( data ) {
					if ( ! data.success ) {
						if ( data.message ) {
							// eslint-disable-next-line no-alert
							alert( data.message );
						}
						return false;
					}
					window.location.href = data.data.redirect;
				} );
				post.fail( function() {
					// eslint-disable-next-line no-alert
					alert( "<?php esc_html_e( 'Network Error. Please try again.', 'buddyboss-app' ); ?>" );
				} );
			} );

			jQuery( '.build-version-select' ).on( 'change', function() {
				const target        = jQuery( this );
				const currentValue = target.val();

				jQuery( this ).parents( 'form' ).find( 'input[name="build-id-updated"]' ).val( currentValue );

				<?php if ( true === $disabled_button ) { ?>
				buildChange();
				<?php } ?>
			} );
		} );
</script>
