<?php
/**
 * Publish - iOS Checklists
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="bbapp-publish-block__finale">
	<div class="flex">
		<div class="left-block">
			<p><?php esc_html_e( 'The BuddyBoss Publishing Service will assist you with publishing your app in the Apple App Store, as well as respond to requests, questions or rejections from Apple. This service is included for all BuddyBoss App customers.', 'buddyboss-app' ); ?></p>
			<p><?php esc_html_e( 'Before you can submit your request, you will need to complete the publishing checklist.', 'buddyboss-app' ); ?></p>
			<p><?php esc_html_e( 'Watch the video tutorial to learn how to complete the checklist, including how to:', 'buddyboss-app' ); ?></p>
			<ul>
				<li><?php esc_html_e( 'Complete your app information', 'buddyboss-app' ); ?></li>
				<li><?php esc_html_e( 'Set your app\'s pricing and availability', 'buddyboss-app' ); ?></li>
				<li><?php esc_html_e( 'Configure your app\'s privacy information', 'buddyboss-app' ); ?></li>
				<li><?php esc_html_e( 'Create and prepare a new version of your app', 'buddyboss-app' ); ?></li>
			</ul>
			<p><?php esc_html_e( 'Once you\'ve completed all the steps in the publishing checklist, complete the questionnaire below to continue.', 'buddyboss-app' ); ?></p>
		</div>
		<div class="right-box-video">
			<div class="video-wrapper">
				<div class="video-container">
					<iframe src="https://player.vimeo.com/video/531222556?byline=0&portrait=0" width="560" height="315" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
				</div>
			</div>
		</div>
	</div>
	<div class="bbapp-publish-block__validate">
		<div class="bbapp-publish-block__accept">
			<p class="radio-group">
				<span><?php esc_html_e( 'Have you entered a name, subtitle, category and EULA for your app in App Store Connect?', 'buddyboss-app' ); ?></span>
				<label>
					<input type="radio" name="confirm-bb-publish-name" value="1" />
					<span class="radio-label"><?php esc_html_e( 'Yes', 'buddyboss-app' ); ?></span>
				</label>
				<label>
					<input type="radio" name="confirm-bb-publish-name" value="0" />
					<span class="radio-label"><?php esc_html_e( 'No', 'buddyboss-app' ); ?></span>
				</label>
			</p>
			<p class="radio-group">
				<span><?php esc_html_e( 'Have you set your app\'s pricing and availability in App Store Connect?', 'buddyboss-app' ); ?></span>
				<label>
					<input type="radio" name="confirm-bb-publish-price" value="1" />
					<span class="radio-label"><?php esc_html_e( 'Yes', 'buddyboss-app' ); ?></span>
				</label>
				<label>
					<input type="radio" name="confirm-bb-publish-price" value="0" />
					<span class="radio-label"><?php esc_html_e( 'No', 'buddyboss-app' ); ?></span>
				</label>
			</p>
			<p class="radio-group">
				<span><?php esc_html_e( 'Have you entered a Privacy Policy URL for your app in App Store Connect?', 'buddyboss-app' ); ?></span>
				<label>
					<input type="radio" name="confirm-bb-publish-ppurl" value="1" />
					<span class="radio-label"><?php esc_html_e( 'Yes', 'buddyboss-app' ); ?></span>
				</label>
				<label>
					<input type="radio" name="confirm-bb-publish-ppurl" value="0" />
					<span class="radio-label"><?php esc_html_e( 'No', 'buddyboss-app' ); ?></span>
				</label>
			</p>
			<p class="radio-group">
				<span><?php esc_html_e( 'Do you give permission for BuddyBoss to manage your app in App Store Connect?', 'buddyboss-app' ); ?></span>
				<label>
					<input type="radio" name="confirm-bb-publish-permission" value="1" />
					<span class="radio-label"><?php esc_html_e( 'Yes', 'buddyboss-app' ); ?></span>
				</label>
				<label>
					<input type="radio" name="confirm-bb-publish-permission" value="0" />
					<span class="radio-label"><?php esc_html_e( 'No', 'buddyboss-app' ); ?></span>
				</label>
			</p>
		</div>
	</div>
	<div class="flex bbapp-publish-block__ctrl">
		<div class="left-block">
			<p class="submit bbapp-publish-block__action">
				<input type="hidden" name="accept-publish" value="">
				<button type="submit" class="button button-primary bbapp-publish-block__confirm" disabled><div class="bbapp_loading dark" style="display:none"></div><?php esc_html_e( 'Confirm', 'buddyboss-app' ); ?></button>
			</p>
		</div>
		<div class="right-block">
			<p class="bbapp-publish-block__action">
				<a href="<?php echo esc_url( 'www.buddyboss.com/files/publishing-checklist-apple.pdf' ); ?>" class="button button-secondary" target="_blank" download><?php esc_html_e( 'Download Checklist PDF', 'buddyboss-app' ); ?></a>
			</p>
		</div>
	</div>
</div>
<script>
	jQuery( document ).ready( function() {
		jQuery( '.bbapp-publish-block__accept input' ).change( function() {
			const _this = jQuery( this );
			const _btn = _this.closest( '.bbapp-publish-block__finale' ).find( '.bbapp-publish-block__confirm' );

			const buttons = jQuery( '.bbapp-publish-block__accept input:radio:checked' ).get();

			const values = jQuery.map( buttons, function( element ) {
				return jQuery( element ).attr( 'value' );
			} );

			if ( values.every( ( value ) => value === '1' ) ) {
				_btn.prop( 'disabled', false );
				jQuery( 'input[name="accept-publish"]' ).val( '1' );

				_btn.click( function() {
					_btn.find( '.bbapp_loading' ).show();
					_btn.addClass( 'btn-disabled' );
				} );
			} else {
				_btn.prop( 'disabled', true );
				jQuery( 'input[name="accept-publish"]' ).val( '' );
			}
		} );
	} );
</script>
