<?php
/**
 * Publish - iOS Checklists Error
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="bbapp-publish-block__finale">
	<div class="bbapp-notice-box bbapp-notice-box--error bbapp-notice-box--icon">
		<span><?php esc_html_e( 'To continue, please resolve the items below in your Apple account.', 'buddyboss-app' ); ?></span>
	</div>
	<?php
	$validated = \BuddyBossApp\AppStores\Apple::instance()->validate_app();
	if ( ! empty( $validated ) ) {
		echo '<ul class="bbapp-cards--full">';
		foreach ( $validated as $validate ) {
			?>
			<li class="bbapp-card">
				<div class="bbapp-card-inner">
					<header class="bbapp-card-header">
						<h4 class="bbapp-card-title"><?php echo esc_html( ! empty( $validate['headline'] ) ? $validate['headline'] : '' ); ?></h4>
						<div class="bb-card-content"><?php echo ( ! empty( $validate['description'] ) ? wp_kses_post( $validate['description'] ) : 'N/A' ); ?></div>
					</header>
					<div class="bbapp-card__ctrl">
						<a class="button" href="<?php echo esc_url( $validate['link'] ); ?>" target="_blank">
							<?php esc_html_e( 'Resolve', 'buddyboss-app' ); ?>
						</a>
					</div>
				</div>
			</li>
			<?php
		}
		echo '</ul>';
	}
	?>
	<p>
		<button type="button" class="button button-primary refresh-apple-checklist">
			<span class="bbapp_loading" style="display:none;"></span>
			<?php esc_html_e( 'Check Again', 'buddyboss-app' ); ?>
		</button>
	</p>
</div>
<script>
	jQuery( document ).ready( function() {
		jQuery( '.refresh-apple-checklist' ).click( function( e ) {
			e.preventDefault();
			const target = jQuery( this );

			target.prop( 'disabled', true ).find( '.bbapp_loading' ).show();

			const post = jQuery.post( ajaxurl, {
				action: 'bbapp_refresh_apple_checklist',
			} );

			post.done( function() {
				location.reload();
			} );

			post.fail( function() {
				target.prop( 'disabled', false ).find( '.bbapp_loading' ).hide();
				// eslint-disable-next-line no-alert
				alert( "<?php esc_html_e( 'Network Error. Please try again.', 'buddyboss-app' ); ?>" );
			} );
		} );
	} );
</script>
