<?php
/**
 * Publish - iOS Publish Builds.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$build_id = ( isset( $_GET['build-id'] ) ? bbapp_input_clean( wp_unslash( $_GET['build-id'] ) ) : '' ); //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
?>

<div class="bbapp-publish-block__finale bbapp-publish-block__version">
	<p><?php esc_html_e( 'Select which build of your iOS app you want to publish to publish to the Apple App Store. Only release app builds can be published.', 'buddyboss-app' ); ?></p>
</div>

<?php
$builds = \BuddyBossApp\Build::instance()->get_app_builds( 'ios', 'live', false, 'completed' );

if ( ! empty( $builds['data'] ) && ! is_wp_error( $builds ) ) {
	?>
	<div class="build-change-wrapper">
		<select class="build-version-select" name="build-id" required>
			<option value=""><?php esc_html_e( '-- Select Build --', 'buddyboss-app' ); ?></option>
			<?php foreach ( $builds['data'] as $b_id => $build ) : ?>
				<option value="<?php echo esc_attr( $build['id'] ); ?>" <?php selected( $build['id'], $build_id ); ?>>
					<?php printf( '%1$s #%2$s %3$s(%4$s)', esc_html__( 'Build', 'buddyboss-app' ), esc_html( $build['id'] ), esc_html( $build['build_version'] ), esc_html( $build['build_version_code'] ) ); ?>
				</option>
			<?php endforeach; ?>
		</select>
		<button type="submit" class="button-primary button confirm-build">
			<div class="bbapp_loading_btn dark" style="display:none"></div>
			<?php esc_html_e( 'Confirm Build', 'buddyboss-app' ); ?>
		</button>
	</div>
<?php } else { ?>
	<div class="bbapp-notice-box bbapp-notice-box--warning">
		<span><?php esc_html_e( 'No iOS Release App Builds to Publish.', 'buddyboss-app' ); ?></span>
	</div>
	<?php
}
?>
<div class="build-ajax-data">
</div>

<script>
	let ajaxPost = '';
	jQuery( document ).ready( function() {
		jQuery( '.build-version-select' ).on( 'change', function() {
			const target        = jQuery( this );
			const currentValue = target.val();
			jQuery( this ).parents( 'form' ).find( 'input[name="tab"]' ).val( 'build' );

			jQuery( this ).parents( 'form' ).find( 'input[name="build-id"]' ).val( currentValue );
			jQuery( '.build-ajax-data' ).empty();
			jQuery( '.build-change-wrapper .bbapp_loading' ).remove();
			jQuery( '.build-change-wrapper' ).append( '<div class="bbapp_loading"></div>' );

			if ( currentValue === '' ) {
				jQuery( '.build-change-wrapper .bbapp_loading' ).remove();
			}

			if ( ajaxPost ) {
				ajaxPost.abort();
			}

			if ( currentValue === '' ) {
				return;
			}

			ajaxPost = jQuery.post( ajaxurl, {
				action: 'bbapp_load_build_data',
				build_version: currentValue,
				platform: 'ios',
			} );

			ajaxPost.always( function () {
				jQuery( '.build-ajax-data' ).empty();
			} );

			ajaxPost.done( function( data ) {
				jQuery( '.build-ajax-data' ).empty();
				jQuery( '.build-change-wrapper .bbapp_loading' ).remove();
				jQuery( '.build-ajax-data' ).append( data );
			} );
		} );

		jQuery( 'button.button.confirm-build' ).click( function() {
			jQuery( this ).find( '.bbapp_loading_btn' ).show();
			jQuery( this ).addClass( 'btn-disabled' );
		} );
	} );
</script>
