<?php
/**
 * Publish - iOS app.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$publish_ios_tabs = array(
	'checklist' => __( 'Publishing Checklist', 'buddyboss-app' ),
	'build'     => __( 'Build Version', 'buddyboss-app' ),
	'version'   => __( 'App Store Version', 'buddyboss-app' ),
	'review'    => __( 'Review Options', 'buddyboss-app' ),
);
$current_tabs     = ( isset( $_GET['tab'] ) ? bbapp_input_clean( wp_unslash( $_GET['tab'] ) ) : 'checklist' ); //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$accept_publish   = (bool) ( isset( $_GET['accept-publish'] ) ? bbapp_input_clean( wp_unslash( $_GET['accept-publish'] ) ) : false ); //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$build_id         = ( isset( $_GET['build-id'] ) ? bbapp_input_clean( wp_unslash( $_GET['build-id'] ) ) : '' ); //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$validated        = \BuddyBossApp\AppStores\Apple::instance()->validate_app();

if ( ! empty( $accept_publish ) && empty( $validated ) && 'checklist' === $current_tabs ) {
	$current_tabs = 'build';
}

$display_app_data = \BuddyBossApp\AppStores\Apple::instance()->display_app_data();
$validate         = array_column( $display_app_data, 'validate' );
$has_error        = ! empty( $display_app_data ) && count( $validate ) > count( array_filter( $validate ) );
$version_confirm  = ( isset( $_GET['version'] ) ? bbapp_input_clean( wp_unslash( $_GET['version'] ) ) : '' ); //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

if ( ! empty( $accept_publish ) && empty( $validated ) && ! empty( $build_id ) && empty( $version_confirm ) ) {
	$current_tabs = 'version';
} elseif ( ! empty( $accept_publish ) && empty( $validated ) && ! empty( $build_id ) && empty( $has_error ) && 'confirmed' === $version_confirm ) {
	$current_tabs = 'review';
}

$tabs_url = array(
	'checklist' => bbapp_get_admin_url( 'admin.php?page=bbapp-publish&tab=checklist' ),
	'build'     => bbapp_get_admin_url( 'admin.php?page=bbapp-publish&accept-publish=1&tab=build' ),
	'version'   => bbapp_get_admin_url( 'admin.php?page=bbapp-publish&accept-publish=1&tab=version&build-id=' . $build_id ),
	'review'    => '',
);

?>
<div class="bbapp-publish-block bbapp-publish-block--card ios">
	<div>
		<h2 class="bbapp-publish-block__ios-heading">
			<i class="bb-icon-f bb-icon-brand-apple"></i>
			<?php esc_html_e( 'Publish Your iOS App', 'buddyboss-app' ); ?>
			<a class="button button-secondary bbapp-tutorial-btn" href="admin.php?page=bbapp-help&article=124544" target="_blank">
				<?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?>
			</a>
		</h2>
		<ul class="publish-tabs">
			<?php
			$selected = false;
			foreach ( $publish_ios_tabs as $key => $publish_ios_tab ) {
				$selected = ( false === $selected && $key === $current_tabs ) ? true : $selected;
				echo wp_kses_post( '<li ' . ( $key === $current_tabs ? 'class="selected"' : '' ) . '>' . ( ( true !== $selected && ! empty( $tabs_url[ $key ] ) ) ? '<a href="' . esc_url( $tabs_url[ $key ] ) . '">' : '' ) . $publish_ios_tab . ( ( true !== $selected && ! empty( $tabs_url[ $key ] ) ) ? '</a>' : '' ) . '</li>' );
			}
			?>
		</ul>
		<form id="publish-app-form" method="get">
			<input type="hidden" name="page" value="bbapp-publish"/>
			<?php if ( ! empty( $accept_publish ) ) { ?>
				<input type="hidden" name="accept-publish" value="<?php echo esc_attr( $accept_publish ); ?>"/>
			<?php } ?>
			<?php if ( ! empty( $build_id ) ) { ?>
				<input type="hidden" name="build-id" value="<?php echo esc_attr( $build_id ); ?>"/>
			<?php } ?>
			<input type="hidden" name="tab" value="<?php echo esc_attr( $current_tabs ); ?>"/>

			<?php
			if ( 'checklist' === $current_tabs && empty( $accept_publish ) ) {
				require dirname( __FILE__ ) . '/publish-ios-checklist.php';
			} elseif ( 'checklist' === $current_tabs && ! empty( $accept_publish ) && ! empty( $validated ) ) {
				require dirname( __FILE__ ) . '/publish-ios-checklist-error.php';
			} elseif ( 'build' === $current_tabs ) {
				require dirname( __FILE__ ) . '/publish-ios-build.php';
			} elseif ( 'version' === $current_tabs ) {
				require dirname( __FILE__ ) . '/publish-ios-version.php';
			} elseif ( 'review' === $current_tabs ) {
				require dirname( __FILE__ ) . '/publish-ios-review.php';
			}
			?>
		</form>
	</div>
</div>
