<?php
/**
 * Publish - iOS Details Customer Completed.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $publish_ios_id;

if ( empty( $publish_ios_id ) ) {
	echo '<p class="bbapp-notice-box bbapp-notice-box--error">' . esc_html__( 'Some required information has not been configured. Please go back end try again.', 'buddyboss-app' ) . '</p>';

	return;
}


$app_icon     = \BuddyBossApp\Admin\Appearance\Branding::instance()->get_upload_file_info( 'app_icon_ios.png' );
$app_icon_url = isset( $app_icon ) && ! empty( $app_icon['fileurl'] ) ? $app_icon['fileurl'] : bbapp()->plugin_url . 'assets/img/bb_app__icon_placeholder.svg';
$app_name     = ! empty( \BuddyBossApp\Admin\Configure::instance()->option( 'publish.general.appname' ) ) ? \BuddyBossApp\Admin\Configure::instance()->option( 'publish.general.appname' ) : __( 'BuddyBoss', 'buddyboss-app' );
?>
<div class="bbapp-publish-block bbapp-publish-block--card ios">
	<div class="publish-information">
		<div class="bbapp-publish-block__completed publish-detail-customer-completed flex">
			<div class="bbapp-publish-block__completed-input">
				<span class="bbapp-publish-request-num"><?php printf( '%1$s #%2$s', esc_html__( 'Request', 'buddyboss-app' ), esc_attr( $publish_ios_id ) ); ?></span>
				<h4 class="bbapp-publish-heading"><?php esc_html_e( 'Your iOS app has been submitted to Apple for review.', 'buddyboss-app' ); ?></h4>
				<div class="bbapp-publish-detail"><p><?php esc_html_e( 'As requested, the BuddyBoss Publishing Team will not respond to Apple on your behalf. You will get a notification from Apple regarding the status of your iOS app submission.', 'buddyboss-app' ); ?></p></div>
				<div class="bbapp-publish-close">
					<h5><?php esc_html_e( 'How to Publish New Versions', 'buddyboss-app' ); ?></h5>
					<p><?php esc_html_e( 'Now that the first version of your BuddyBoss App has been approved by Apple, you can publish new versions by following the steps in our "Publishing to the Apple App Store" tutorial.', 'buddyboss-app' ); ?></p>
					<a class="button button-primary bbapp-tutorial-btn" href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-help&article=124109' ) ); ?>" target="_blank"><?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?></a>
				</div>
			</div>
			<div class="bbapp-publish-block__completed-figure">
				<div class="bbapp-publish-block__completed-device">
					<div class="bbapp-publish-screen-data flex">
						<div class="bbapp-publish-screen-icon">
							<img src="<?php echo esc_url( $app_icon_url ); ?>" alt="<?php esc_html_e( 'BuddyBoss', 'buddyboss-app' ); ?>" />
						</div>
						<div class="bbapp-publish-screen-title">
							<span class="<?php echo ( ! empty( $app_name ) ) ? 'has-appname' : 'empty-appname'; ?>"><?php echo esc_html( $app_name ); ?></span>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
