<?php
/**
 * Publish - iOS Details Completed.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $publish_ios_id;

if ( empty( $publish_ios_id ) ) {
	echo '<p class="bbapp-notice-box bbapp-notice-box--error">' . esc_html__( 'Some required information has not been configured. Please go back end try again.', 'buddyboss-app' ) . '</p>';

	return;
}

$app_icon     = \BuddyBossApp\Admin\Appearance\Branding::instance()->get_upload_file_info( 'app_icon_ios.png' );
$app_icon_url = isset( $app_icon ) && ! empty( $app_icon['fileurl'] ) ? $app_icon['fileurl'] : bbapp()->plugin_url . 'assets/img/bb_app__icon_placeholder.svg';
$app_name     = ! empty( \BuddyBossApp\Admin\Configure::instance()->option( 'publish.general.appname' ) ) ? \BuddyBossApp\Admin\Configure::instance()->option( 'publish.general.appname' ) : __( 'BuddyBoss', 'buddyboss-app' );
?>
<div class="bbapp-publish-block bbapp-publish-block--card ios">
	<div class="publish-information">
		<div class="bbapp-publish-block__completed publish-detail-completed flex">
			<div class="bbapp-publish-block__completed-input">
				<span class="bbapp-publish-request-num"><?php printf( '%1$s #%2$s', esc_html__( 'Request', 'buddyboss-app' ), esc_attr( $publish_ios_id ) ); ?></span>
				<h4 class="bbapp-publish-heading"><?php esc_html_e( 'Congratulations', 'buddyboss-app' ); ?></h4>
				<h5 class="bbapp-publish-subheading"><?php esc_html_e( 'Your iOS app has been approved for publishing into the Apple App Store.', 'buddyboss-app' ); ?></h5>
				<div class="bbapp-publish-detail">
					<p><?php esc_html_e( 'In case you chose to automatically release this version into the Apple App Store, your app should now be released. However, it can take up to 24 hours for your app to be available on the Apple App Store.', 'buddyboss-app' ); ?></p>
					<p><?php esc_html_e( 'If you selected to automatically release your iOS app on a specific date, then this version of your app will be available on the Apple App Store on that date', 'buddyboss-app' ); ?></p>
					<p><?php printf( '%1$s <a href="https://appstoreconnect.apple.com/">%2$s</a> %3$s', esc_html__( 'If you chose to manually release this version into the Apple App Store, you can now log into your', 'buddyboss-app' ), esc_html__( 'App Store Connect', 'buddyboss-app' ), esc_html__( 'account and do so.', 'buddyboss-app' ) ); ?></p>
				</div>
				<div class="bbapp-publish-close">
					<h5><?php esc_html_e( 'How to Publish New Versions', 'buddyboss-app' ); ?></h5>
					<p><?php esc_html_e( 'Now that the first version of your BuddyBoss App has been approved by Apple, you can publish new versions by following the steps in our "Publishing to the Apple App Store" tutorial.', 'buddyboss-app' ); ?></p>
					<a class="button button-primary bbapp-tutorial-btn" href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-help&article=124109' ) ); ?>" target="_blank"><?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?></a>
				</div>
			</div>
			<div class="bbapp-publish-block__completed-figure">
				<div class="bbapp-publish-block__completed-device">
					<div class="bbapp-publish-screen-data flex">
						<div class="bbapp-publish-screen-icon">
							<img src="<?php echo esc_url( $app_icon_url ); ?>" alt="<?php esc_html_e( 'BuddyBoss', 'buddyboss-app' ); ?>"/>
						</div>
						<div class="bbapp-publish-screen-title">
							<span class="<?php echo ( ! empty( $app_name ) ) ? 'has-appname' : 'empty-appname'; ?>"><?php echo esc_html( $app_name ); ?></span>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
