<?php
/**
 * Publish - iOS Publish Build Detail.
 *
 * @package BuddyBossApp\Admin;
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$build_id = isset( $_POST['build_version'] ) ? bbapp_input_clean( wp_unslash( $_POST['build_version'] ) ) : 0; //phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$platform = isset( $_POST['platform'] ) ? bbapp_input_clean( wp_unslash( $_POST['platform'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

if ( ! empty( $build_id ) ) {
	$get_build_details = \BuddyBossApp\Admin\Build\Build::instance()->get_build_details( $build_id );
	$build_details     = \BuddyBossApp\Admin\Build\Build::instance()->get_build_information( $get_build_details );

	if ( ! empty( $build_details ) ) {
		$build_version      = ( isset( $get_build_details[ $platform ]['app_version'] ) ? $get_build_details[ $platform ]['app_version'] : '0.0.0' );
		$build_version_code = ( isset( $get_build_details[ $platform ]['app_version_code'] ) ? $get_build_details[ $platform ]['app_version_code'] : '0' );

		if ( isset( $build_details['ios']['app_version_ios'] ) ) {
			unset( $build_details['ios']['app_version_ios'] );
		}

		if ( isset( $build_details['ios']['app_version_code_ios'] ) ) {
			unset( $build_details['ios']['app_version_code_ios'] );
		}

		if ( isset( $build_details['android']['app_version_android'] ) ) {
			unset( $build_details['android']['app_version_android'] );
		}

		if ( isset( $build_details['android']['app_version_code_android'] ) ) {
			unset( $build_details['android']['app_version_code_android'] );
		}
		?>
		<div class="build-data">
			<div class="build-data__unit">
				<p>
					<?php printf( '<strong>%1$s</strong> %2$s', esc_html__( 'Build #', 'buddyboss-app' ) . esc_html( $build_id ), esc_html( $build_version ) . esc_html( '(' . $build_version_code . ')' ) ); ?>
				</p>
			</div>
			<table width="100%" class="form-table">
				<?php
				foreach ( $build_details as $rinfo_name => $rinfo ) {
					if ( 'files' === $rinfo_name ) {
						continue;
					}

					if ( 'ios' === $rinfo_name && ! empty( $rinfo ) ) {
						?>
						<tr class="bbapp-card">
							<th colspan="2" class="header-row">
								<h4 class="bbapp-card-title"><?php esc_html_e( 'iOS Settings', 'buddyboss-app' ); ?></h4>
							</th>
						</tr>
						<?php
					}

					if ( 'android' === $rinfo_name && ! empty( $rinfo ) ) {
						?>
						<tr class="bbapp-card">
							<th colspan="2" class="header-row">
								<h4 class="bbapp-card-title"><?php esc_html_e( 'Android Settings', 'buddyboss-app' ); ?></h4>
							</th>
						</tr>
						<?php
					}

					if ( is_array( $rinfo ) ) {
						if ( ! empty( $rinfo ) ) {
							foreach ( $rinfo as $cinfo_name => $cinfo ) {
								if ( 'files' === $cinfo_name ) {
									continue;
								}
								?>
								<tr class="bbapp-card">
									<th <?php echo( ( isset( $cinfo['type'] ) && 'header' === $cinfo['type'] ) ? 'colspan="2" class="header-row"' : '' ); ?>>
										<h4 class="bbapp-card-title"><?php echo esc_html( ! empty( $cinfo['label_prefix'] ) ? $cinfo['label_prefix'] . ' ' : '' ) . esc_html( $cinfo['label'] ); ?></h4>
									</th>
									<?php if ( ! isset( $cinfo['type'] ) || 'header' !== $cinfo['type'] ) { ?>
										<td>
											<?php
											echo '<div class="bb-card-content">';
											if ( empty( $cinfo['value'] ) ) {
												$cinfo['value'] = __( 'N/A', 'buddyboss-app' );
											}

											if ( isset( $cinfo['is_image'] ) ) {
												echo '<img src="' . esc_attr( $cinfo['value'] ) . '" class="bbapp-image-preview" />';
											} elseif ( isset( $cinfo['preview'] ) ) {
												echo wp_kses_post( $cinfo['preview'] );
											} else {
												echo esc_html( $cinfo['value'] );
											}
											echo '</div>';
											?>
										</td>
									<?php } ?>
								</tr>
								<?php
							}
						}
					} else {
						?>
						<tr class="bbapp-card">
							<th <?php echo( ( isset( $rinfo['type'] ) && 'header' === $rinfo['type'] ) ? 'colspan="2" class="header-row"' : '' ); ?>>
								<h4 class="bbapp-card-title"><?php echo esc_attr( $rinfo['label'] ); ?></h4>
							</th>
							<?php if ( ! isset( $rinfo['type'] ) || 'header' !== $rinfo['type'] ) { ?>
								<td>
									<?php
									echo '<div class="bb-card-content">';
									if ( empty( $rinfo['value'] ) ) {
										$rinfo['value'] = __( 'N/A', 'buddyboss-app' );
									}

									if ( isset( $rinfo['is_image'] ) ) {
										echo '<img src="' . esc_attr( $rinfo['value'] ) . '" class="bbapp-image-preview" />';
									} elseif ( isset( $rinfo['preview'] ) ) {
										echo wp_kses_post( $rinfo['preview'] );
									} else {
										echo esc_html( $rinfo['value'] );
									}
									echo '</div>';
									?>
								</td>
							<?php } ?>
						</tr>
						<?php
					}
				}
				?>
			</table>
		</div>
		<?php
	}
}
?>
