<?php
/**
 * Publish - Android
 *
 * @package BuddyBossApp\Admin;
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use BuddyBossApp\AppStores\Android;

$account_connection = Android::instance()->is_connected();
$action_get         = ( ! empty( $_GET['action'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['action'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

if ( 'create' === $action_get && 'status' === $this->get_current_step() ) {
	include dirname( __FILE__ ) . '/publish-status.php';
} elseif ( Android::instance()->is_connected() ) {
	$app_package_registered = \BuddyBossApp\AppSettings::instance()->get_setting_value( 'publish.android.namespace.registered' );
	if ( empty( $app_package_registered ) && 1 !== $app_package_registered ) {
		?>
		<div class="bbapp-publish-block bbapp-publish-block--card android">
			<h2 class="bbapp-publish-block__android-heading">
				<i class="bb-icon-rf bb-icon-brand-android"></i>
				<?php esc_html_e( 'Register Your Application ID', 'buddyboss-app' ); ?>
			</h2>
			<div class="data-update-ajax">
				<p>
					<?php echo sprintf( '%1$s %2$s', esc_html__( 'To continue, you need to register your Android app\'s Application ID by uploading a release app build to your app in the', 'buddyboss-app' ), wp_kses_post( '<a href="https://play.google.com/apps/publish" target="_blank">' . esc_html__( 'Google Developer Play Console', 'buddyboss-app' ) . '</a>.' ) ); ?>
				</p>
				<p>
					<?php printf( '%1$s <a href="%2$s">%3$s</a> %4$s', esc_html__( 'Once registered, check the checkbox in the Register Application ID section on the', 'buddyboss-app' ), esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-configure&setting=android#app_settings_app_publish_android_live_settings' ) ), esc_html__( 'Android Settings', 'buddyboss-app' ), esc_html__( 'page.', 'buddyboss-app' ) ); ?>
				</p>
				<a href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-configure&setting=android' ) ); ?>" class="button button-primary">
					<?php esc_html_e( 'Register Now', 'buddyboss-app' ); ?>
				</a>
				<a href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-help&article=122254' ) ); ?>" class="button button-secondary" target="_blank">
					<?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?>
				</a>
			</div>
		</div>
		<?php
	} elseif ( 1 !== Android::instance()->is_google_connected() || ( false === $account_connection || is_wp_error( $account_connection ) ) ) {
		?>
		<div class="bbapp-publish-block android">
			<h2>
				<?php esc_html_e( 'Unable To Connect To Your App', 'buddyboss-app' ); ?>
			</h2>
			<div class="data-update-ajax">
				<p>
					<?php printf( '%1$s %2$s', esc_html__( 'Please ensure you\'ve uploaded a release app build to your app in the', 'buddyboss-app' ), wp_kses_post( '<a href="https://play.google.com/apps/publish" target="_blank">' . esc_html__( 'Google Developer Play Console', 'buddyboss-app' ) . '</a>.' ) ); ?>
				</p>
				<p>
					<?php esc_html_e( 'If you\'ve already done so, make sure the Service Account Key you are connected with has the following permissions for your app:', 'buddyboss-app' ); ?>
				</p>
				<ul class="list-style">
					<li><?php esc_html_e( 'View app information and download bulk reports', 'buddyboss-app' ); ?></li>
					<li><?php esc_html_e( 'View financial data, orders, and cancellation survey responses', 'buddyboss-app' ); ?></li>
					<li><?php esc_html_e( 'Create, edit and delete draft apps', 'buddyboss-app' ); ?></li>
					<li><?php esc_html_e( 'Release to production, exclude devices, and use Play App Signing', 'buddyboss-app' ); ?></li>
					<li><?php esc_html_e( 'Release apps to testing tracks', 'buddyboss-app' ); ?></li>
					<li><?php esc_html_e( 'Manage testing tracks and edit tester lists', 'buddyboss-app' ); ?></li>
				</ul>
				<button class="button button-primary bbapp-check-google-permission">
					<div class="bbapp_loading dark" style="display:none"></div>
					<?php esc_html_e( 'Check Again', 'buddyboss-app' ); ?>
				</button>
				<a href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-help&article=122254' ) ); ?>" class="button button-secondary" target="_blank">
					<?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?>
				</a>
			</div>
		</div>
		<?php
	} else {
		\BuddyBossApp\Publish::instance()->check_publish_status();
		$publish_option  = \BuddyBossApp\Publish::instance()->get_publish_options();
		$publish_history = BuddyBossApp\Admin\Publish\Publish::instance()->get_publish_history( 'android' );
		$publish_history = (
			! empty( $publish_history ) &&
			! is_wp_error( $publish_history ) &&
			! empty( $publish_history['data'] )
		) ? array_column( $publish_history['data'], 'status', 'id' ) : array();
		global $publish_android_id;
		$publish_android_id = '';
		if (
			! empty( $publish_option ) &&
			! empty( $publish_option['publish_requested'] ) &&
			! empty( $publish_option['publish_requested']['android'] ) &&
			! empty( $publish_option['publish_requested']['android']['publish_id'] ) &&
			! empty( $publish_option['publish_requested']['android']['publish_status'] ) &&
			! in_array( $publish_option['publish_requested']['android']['publish_status'], array( 'cancelled' ), true )
		) {
			$publish_android_id = $publish_option['publish_requested']['android']['publish_id'];
			$publish_details    = \BuddyBossApp\Admin\Publish\Publish::instance()->get_publish_details( $publish_android_id );

			if ( empty( $publish_details ) ) {
				require dirname( __FILE__ ) . '/publish-android-app.php';
			} else {
				require dirname( __FILE__ ) . '/publish-android-detail.php';
			}
		} elseif (
			! empty( $publish_history ) &&
			'cancelled' !== current( $publish_history ) &&
			! empty( array_key_first( $publish_history ) )
		) {
			$publish_android_id = array_key_first( $publish_history );
			$publish_details    = \BuddyBossApp\Admin\Publish\Publish::instance()->get_publish_details( $publish_android_id );

			if ( empty( $publish_details ) ) {
				require dirname( __FILE__ ) . '/publish-android-app.php';
			} else {
				require dirname( __FILE__ ) . '/publish-android-detail.php';
			}
		} else {
			require dirname( __FILE__ ) . '/publish-android-app.php';
		}
	}
} else {
	?>
	<div class="bbapp-publish-block bbapp-publish-block--card android">
		<h2 class="bbapp-publish-block__android-heading">
			<i class="bb-icon-rf bb-icon-brand-android"></i>
			<?php esc_html_e( 'Connect Your Google Developer Account', 'buddyboss-app' ); ?>
		</h2>
		<div class="data-update-ajax">
			<p>
				<?php esc_html_e( 'You must connect your Google Developer Account to publish Android builds through the BuddyBoss Publishing Service.', 'buddyboss-app' ); ?>
			</p>
			<a href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-configure&setting=android' ) ); ?>" class="button button-primary">
				<?php esc_html_e( 'Connect Now', 'buddyboss-app' ); ?>
			</a>
			<a href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-help&article=122276' ) ); ?>" class="button button-secondary" target="_blank">
				<?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?>
			</a>
		</div>
	</div>
	<?php
}
?>
<script>
	jQuery( document ).ready( function( $ ) {
		$( document ).on( 'click', '.bbapp-check-google-permission', function( e ) {
			e.preventDefault();
			const curObj = $( this );
			curObj.parent().find( '.bbapp-notice-box' ).remove();
			curObj.prop( 'disabled', true );
			const loader = curObj.find( '.bbapp_loading' );
			loader.css( 'display', 'inline-block' );
			const data = {
				action: 'bbapp_validate_google_permissions',
			};

			const permissionCheck = $.post( ajaxurl, data );

			permissionCheck.done( function( response ) {
				loader.css( 'display', 'none' );
				curObj.prop( 'disabled', false );
				if ( true === response.success ) {
					window.location.reload();
				} else {
					curObj.parent().append( '<div class="bbapp-notice-box bbapp-notice-box--warning">' + response.data.message + '</div>' );
				}
			} );
		} );
	} );
</script>
