<?php
/**
 * Publish - Android app review.
 *
 * @package BuddyBossApp\Admin;
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<div class="bbapp-publish-block__finale">
	<p><?php esc_html_e( 'The BuddyBoss Publishing Team can check your submission details and build prior to submission to Google in order to make sure they fulfill Google\'s requirements for approval.', 'buddyboss-app' ); ?></p>
	<p><?php esc_html_e( 'In addition, the team will also respond to any requests, questions or rejections from the Google Play Store until your app is approved. Alternatively, you can respond to Google yourself.', 'buddyboss-app' ); ?></p>
	<input type="hidden" name="skip-bb-review" value="1"/>
	<h4><?php esc_html_e( 'Do you want BuddyBoss to respond to Google?', 'buddyboss-app' ); ?></h4>
	<p class="radio-group">
		<label>
			<input type="radio" name="respond-to-request" value="1"/>
			<span class="radio-label"><?php esc_html_e( 'Yes', 'buddyboss-app' ); ?></span>
		</label>
		<label>
			<input type="radio" name="respond-to-request" value="0"/>
			<span class="radio-label"><?php esc_html_e( 'No', 'buddyboss-app' ); ?></span>
		</label>
	</p>
	<p class="submit">
		<input type="hidden" name="create-publish-nonce" id="create-publish-nonce" value="<?php echo esc_attr( wp_create_nonce( 'create-publish-nonce' ) ); ?>"/>
		<input type="hidden" name="action" value="bbapp_publish_app"/>
		<input type="hidden" name="platform" value="android"/>
		<button type="submit" class="button button-primary create-publish-app" disabled>
			<span class="bbapp_loading" style="display:none;"></span>
			<?php esc_html_e( 'Submit for Review', 'buddyboss-app' ); ?>
		</button>
	</p>
</div>
<script>
	function enableSubmit() {
		const respondToRequest = jQuery( 'input[name="respond-to-request"]:checked' ).val();
		if ( respondToRequest === undefined ) {
			jQuery( '.create-publish-app' ).prop( 'disabled', true );
		} else {
			jQuery( '.create-publish-app' ).prop( 'disabled', false );
		}
	}

	jQuery( document ).ready( function () {
		jQuery( '#publish-app-form' ).submit( function( e ) {
			e.preventDefault();

			jQuery( '.create-publish-app' ).prop( 'disabled', true ).find( '.bbapp_loading' ).show();

			const post = jQuery.ajax( {
				type: 'POST',
				url: ajaxurl,
				data: new FormData( this ),
				dataType: 'json',
				contentType: false,
				cache: false,
				processData: false,
			} );

			post.always( function() {
				jQuery( '.create-publish-app' ).prop( 'disabled', false ).find( '.bbapp_loading' ).hide();
			} );

			post.done( function( data ) {
				if ( ! data.success ) {
					if ( data.message ) {
						// eslint-disable-next-line no-alert
						alert( data.message );
					}
					return false;
				}
				window.location.href = data.data.redirect;
			} );
			post.fail( function() {
				// eslint-disable-next-line no-alert
				alert( "<?php esc_html_e( 'Network Error. Please try again.', 'buddyboss-app' ); ?>" );
			} );
		} );

		jQuery( 'input[name="respond-to-request"]' ).change( function() {
			enableSubmit();
		} );
	} );
</script>
