<?php
/**
 * Publish - Android Checklists.
 *
 * @package BuddyBossApp\Admin;
 */

use BuddyBossApp\ManageApp;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="bbapp-publish-block__finale">
	<div class="flex">
		<div class="left-block">
			<p><?php esc_html_e( 'The BuddyBoss Publishing Service will assist you with reviewing and submitting your app for publishing in the Google Play Store, as well as respond to requests, questions or rejections from Google. This service is included for all BuddyBoss App customers.', 'buddyboss-app' ); ?></p>
			<p><?php esc_html_e( 'Before you can submit your request, you will need to complete the publishing checklist.', 'buddyboss-app' ); ?></p>
			<p><?php esc_html_e( 'Watch the video tutorial to learn how to complete the checklist, including how to:', 'buddyboss-app' ); ?></p>
			<ul>
				<li><?php esc_html_e( 'Invite the BuddyBoss Publishing Team to manage your app', 'buddyboss-app' ); ?></li>
				<li><?php esc_html_e( 'Set up your app\'s content settings and store listing', 'buddyboss-app' ); ?></li>
				<li><?php esc_html_e( 'Create and prepare a release build for your app', 'buddyboss-app' ); ?></li>
			</ul>
			<p><?php esc_html_e( 'Once you\'ve completed all the steps in the publishing checklist, complete the questionnaire below to continue.', 'buddyboss-app' ); ?></p>
		</div>
		<div class="right-box-video">
			<div class="video-wrapper">
				<div class="video-container">
					<iframe src="https://player.vimeo.com/video/531224721?byline=0&portrait=0" width="560"
							height="315" frameborder="0"
							allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture"
							allowfullscreen></iframe>
				</div>
			</div>
		</div>
	</div>
	<div class="bbapp-publish-block__validate">
		<div class="bbapp-publish-block__accept">
			<p class="radio-group">
				<span><?php esc_html_e( 'Have you configured your app\'s content settings (access, ads, ratings, audience, news) in the Google Play Console?', 'buddyboss-app' ); ?></span>
				<label>
					<input type="radio" name="confirm-bb-content-settings" value="1"/>
					<span class="radio-label"><?php esc_html_e( 'Yes', 'buddyboss-app' ); ?></span>
				</label>
				<label>
					<input type="radio" name="confirm-bb-content-settings" value="0"/>
					<span class="radio-label"><?php esc_html_e( 'No', 'buddyboss-app' ); ?></span>
				</label>
			</p>
			<p class="radio-group">
				<span>
					<?php esc_html_e( 'Have you entered your app\'s category and contact information in the Google Play Console?', 'buddyboss-app' ); ?>
				</span>
				<label>
					<input type="radio" name="confirm-bb-app-category" value="1"/>
					<span class="radio-label"><?php esc_html_e( 'Yes', 'buddyboss-app' ); ?></span>
				</label>
				<label>
					<input type="radio" name="confirm-bb-app-category" value="0"/>
					<span class="radio-label"><?php esc_html_e( 'No', 'buddyboss-app' ); ?></span>
				</label>
			</p>
			<p class="radio-group">
				<span>
					<?php esc_html_e( 'Have you configured which countries and regions your app will be available from in the Google Play Console?', 'buddyboss-app' ); ?>
				</span>
				<label>
					<input type="radio" name="confirm-bb-app-countries" value="1"/>
					<span class="radio-label"><?php esc_html_e( 'Yes', 'buddyboss-app' ); ?></span>
				</label>
				<label>
					<input type="radio" name="confirm-bb-app-countries" value="0"/>
					<span class="radio-label"><?php esc_html_e( 'No', 'buddyboss-app' ); ?></span>
				</label>
			</p>
			<p class="radio-group">
				<span>
					<?php esc_html_e( 'Have you uploaded description and screenshots to you app\'s main store listing in the Google Play Console?', 'buddyboss-app' ); ?>
				</span>
				<label>
					<input type="radio" name="confirm-bb-app-description" value="1"/>
					<span class="radio-label"><?php esc_html_e( 'Yes', 'buddyboss-app' ); ?></span>
				</label>
				<label>
					<input type="radio" name="confirm-bb-app-description" value="0"/>
					<span class="radio-label"><?php esc_html_e( 'No', 'buddyboss-app' ); ?></span>
				</label>
			</p>
			<p class="radio-group">
				<span>
					<?php echo sprintf( '%1$s %2$s %3$s', esc_html__( 'Have you invited', 'buddyboss-app' ), esc_html( ManageApp::instance()->get_appcenter_publisher_email_address() ), esc_html__( 'to manage your app in the Google Play Console?', 'buddyboss-app' ) ); ?>
				</span>
				<label>
					<input type="radio" name="confirm-bb-app-invite" value="1"/>
					<span class="radio-label"><?php esc_html_e( 'Yes', 'buddyboss-app' ); ?></span>
				</label>
				<label>
					<input type="radio" name="confirm-bb-app-invite" value="0"/>
					<span class="radio-label"><?php esc_html_e( 'No', 'buddyboss-app' ); ?></span>
				</label>
			</p>
		</div>
	</div>
	<div class="flex bbapp-publish-block__ctrl">
		<div class="left-block">
			<p class="submit bbapp-publish-block__action">
				<input type="hidden" name="accept-publish" value="">
				<button type="submit" class="button button-primary bbapp-publish-block__confirm" disabled>
			<div class="bbapp_loading dark" style="display:none"></div>
			<?php esc_html_e( 'Confirm', 'buddyboss-app' ); ?>
			</button>
			</p>
		</div>
		<div class="right-block">
			<p class="bbapp-publish-block__action">
				<a href="<?php echo esc_url( 'www.buddyboss.com/files/publishing-checklist-google.pdf' ); ?>" class="button button-secondary" target="_blank" download>
					<?php esc_html_e( 'Download Checklist PDF', 'buddyboss-app' ); ?>
				</a>
			</p>
		</div>
	</div>
</div>

<script>
	jQuery( document ).ready( function() {
		jQuery( '.bbapp-publish-block__accept input' ).change( function() {
			const _this = jQuery( this );
			const _btn = _this.closest( '.bbapp-publish-block__finale' ).find( '.bbapp-publish-block__confirm' );
			const buttons = jQuery( '.bbapp-publish-block__accept input:radio:checked' ).get();
			const values = jQuery.map( buttons, function( element ) {
				return jQuery( element ).attr( 'value' );
			} );
			const compareObj = ['1', '1', '1', '1', '1'];

			if ( values.every( ( value ) => value === '1' ) ) {
				_btn.prop( 'disabled', false );
				jQuery( 'input[name="accept-publish"]' ).val( '1' );

				_btn.click( function() {
					_btn.find( '.bbapp_loading' ).show();
					_btn.addClass( 'btn-disabled' );
				} );
			} else {
				_btn.prop( 'disabled', true );
				jQuery( 'input[name="accept-publish"]' ).val( '' );
			}
		} );
	} );
</script>
