<?php
/**
 * Publish - Android app.
 *
 * @package BuddyBossApp\Admin;
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$publish_android_tabs = array(
	'checklist' => __( 'Publishing Checklist', 'buddyboss-app' ),
	'build'     => __( 'Build Version', 'buddyboss-app' ),
	'details'   => __( 'Google Play Details', 'buddyboss-app' ),
	'review'    => __( 'Review Options', 'buddyboss-app' ),
);

$current_tabs    = ( isset( $_GET['tab'] ) ? bbapp_input_clean( wp_unslash( $_GET['tab'] ) ) : 'checklist' ); //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$accept_publish  = (bool) ( isset( $_GET['accept-publish'] ) ? bbapp_input_clean( wp_unslash( $_GET['accept-publish'] ) ) : false ); //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$build_id        = ( isset( $_GET['build-id'] ) ? bbapp_input_clean( wp_unslash( $_GET['build-id'] ) ) : '' ); //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$validated       = \BuddyBossApp\AppStores\Android::instance()->validate_app();
$version_confirm = ( isset( $_GET['version'] ) ? bbapp_input_clean( wp_unslash( $_GET['version'] ) ) : '' ); //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$developer_id    = ( isset( $_GET['developer_id'] ) ? bbapp_input_clean( wp_unslash( $_GET['developer_id'] ) ) : '' ); //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

if ( ! empty( $accept_publish ) && empty( $validated ) && 'checklist' === $current_tabs ) {
	$current_tabs = 'build';
}

if ( ! empty( $accept_publish ) && empty( $validated ) && ! empty( $build_id ) && empty( $version_confirm ) ) {
	$current_tabs = 'details';
} elseif ( ! empty( $accept_publish ) && empty( $validated ) && ! empty( $build_id ) && 'confirmed' === $version_confirm && ! empty( $developer_id ) ) {
	$current_tabs = 'review';
}

$tabs_url = array(
	'checklist' => bbapp_get_admin_url( 'admin.php?page=bbapp-publish&setting=android&tab=checklist' ),
	'build'     => bbapp_get_admin_url( 'admin.php?page=bbapp-publish&setting=android&accept-publish=1&tab=build' ),
	'details'   => bbapp_get_admin_url( 'admin.php?page=bbapp-publish&setting=android&accept-publish=1&tab=details&build-id=' . $build_id ),
	'review'    => '',
);
?>

<div class="bbapp-publish-block bbapp-publish-block--card android">
	<div>
		<h2 class="bbapp-publish-block__android-heading">
			<i class="bb-icon-rf bb-icon-brand-android"></i>
			<?php esc_html_e( 'Publish Your Android App', 'buddyboss-app' ); ?>
			<a class="button button-secondary bbapp-tutorial-btn" href="admin.php?page=bbapp-help&article=124544" target="_blank">
				<?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?>
			</a>
		</h2>
		<ul class="publish-tabs">
			<?php
			$selected = false;
			foreach ( $publish_android_tabs as $key => $publish_android_tab ) {
				$selected = ( false === $selected && $key === $current_tabs ) ? true : $selected;
				echo wp_kses_post( '<li ' . ( $key === $current_tabs ? 'class="selected"' : '' ) . '>' . ( ( true !== $selected && ! empty( $tabs_url[ $key ] ) ) ? '<a href="' . esc_url( $tabs_url[ $key ] ) . '">' : '' ) . $publish_android_tab . ( ( true !== $selected && ! empty( $tabs_url[ $key ] ) ) ? '</a>' : '' ) . '</li>' );
			}
			?>
		</ul>
		<form id="publish-app-form" method="get">
			<input type="hidden" name="page" value="bbapp-publish"/>
			<input type="hidden" name="setting" value="android"/>
			<?php if ( ! empty( $accept_publish ) ) { ?>
				<input type="hidden" name="accept-publish" value="<?php echo esc_attr( $accept_publish ); ?>"/>
			<?php } ?>
			<?php if ( ! empty( $build_id ) ) { ?>
				<input type="hidden" name="build-id" value="<?php echo esc_attr( $build_id ); ?>"/>
			<?php } ?>
			<?php if ( ! empty( $developer_id ) ) { ?>
				<input type="hidden" name="developer_id" value="<?php echo esc_attr( $developer_id ); ?>"/>
			<?php } ?>
			<input type="hidden" name="tab" value="<?php echo esc_attr( $current_tabs ); ?>"/>
			<?php
			if ( 'checklist' === $current_tabs && empty( $accept_publish ) ) {
				require dirname( __FILE__ ) . '/publish-android-checklist.php';
			} elseif ( 'checklist' === $current_tabs && ! empty( $accept_publish ) && ! empty( $validated ) ) {
				require dirname( __FILE__ ) . '/publish-android-checklist-error.php';
			} elseif ( 'build' === $current_tabs ) {
				require dirname( __FILE__ ) . '/publish-android-build.php';
			} elseif ( 'details' === $current_tabs ) {
				require dirname( __FILE__ ) . '/google-play-details.php';
			} elseif ( 'review' === $current_tabs ) {
				require dirname( __FILE__ ) . '/publish-android-review.php';
			}
			?>
		</form>
	</div>
</div>
