<?php
/**
 * Publish - Google Play details.
 *
 * @package BuddyBossApp\Admin;
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use BuddyBossApp\AppStores\Android;

$build_id     = ( isset( $_GET['build-id'] ) ? bbapp_input_clean( wp_unslash( $_GET['build-id'] ) ) : '' ); //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$release_data = Android::instance()->get_release_data( true );
?>
<table width="100%" class="form-table">
	<tbody>
	<tr class="bbapp-card">
		<th colspan="2" class="header-row">
			<h4 class="bbapp-card-title">
				<?php
				esc_html_e( 'Account Details', 'buddyboss-app' );
				?>
			</h4>
		</th>
	</tr>
	<tr class="bbapp-card">
		<td colspan="2">
			<?php
			printf( '%s <a href="%s" target="_blank">%s</a>%s', esc_html__( 'Please enter the Developer ID of your Google account. You can find this by logging into the', 'buddyboss-app' ), esc_url( 'https://play.google.com/console/developers' ), esc_html__( 'Google Play Console', 'buddyboss-app' ), esc_html__( ', then going to Settings > Developer account > Account details.', 'buddyboss-app' ) );
			?>
		</td>
	</tr>
	<tr class="bbapp-card">
		<th>
			<label for="developer-id">
				<?php
				esc_html_e( 'Developer ID', 'buddyboss-app' );
				?>
			</label>
		</th>
		<td>
			<input id="developer-id" type="text" name="developer_id"/>
		</td>
	</tr>
	<tr class="bbapp-card">
		<th colspan="2" class="header-row">
			<h4 class="bbapp-card-title">
				<?php
				esc_html_e( 'Release Details', 'buddyboss-app' );
				?>
			</h4>
		</th>
	</tr>
	<tr class="bbapp-card">
		<td colspan="2">
			<?php
			esc_html_e( 'We will publish your app to the Production track for your app in the Google Play Console. Please confirm the release name and notes below before submitting.', 'buddyboss-app' );
			?>
		</td>
	</tr>
	<tr class="bbapp-card">
		<th>
			<label for="developer-id">
				<?php
				esc_html_e( 'Release Name', 'buddyboss-app' );
				?>
			</label>
		</th>
		<td>
			<?php
			if ( ! empty( $release_data['name'] ) ) {
				echo esc_html( $release_data['name'] );
			}
			?>
		</td>
	</tr>
	<tr class="bbapp-card">
		<th>
			<label for="developer-id">
				<?php
				esc_html_e( 'Release Notes', 'buddyboss-app' );
				?>
			</label>
		</th>
		<td>
			<?php
			if ( ! empty( $release_data['release_notes'] ) ) {
				foreach ( $release_data['release_notes'] as $release_note ) {
					?>
					<strong>
						<?php echo esc_html( Android::instance()->get_language( $release_note['language'] ) ); ?>
					</strong>
					<p>
						<?php echo esc_html( $release_note['notes'] ); ?>
					</p>
					<?php
				}
			}
			?>
		</td>
	</tr>
	<tr class="bbapp-card">
		<th colspan="2">
			<input type="hidden" name="version" value="confirmed"/>
			<input type="hidden" name="tab" value="review"/>
			<input type="hidden" name="build-id" value="<?php echo esc_attr( $build_id ); ?>"/>
			<button type="submit" class="button button-primary bbapp-publish-block__confirm" disabled>
				<div class="bbapp_loading dark" style="display:none"></div>
				<?php esc_html_e( 'Confirm Details', 'buddyboss-app' ); ?>
			</button>
		</th>
	</tr>
	</tbody>
</table>
<script>
	jQuery( document ).ready( function() {
		jQuery( 'input[name="developer_id"]' ).on( 'input', function() {
			const value = jQuery( this ).val();
			const _btn  = jQuery( '.bbapp-publish-block__confirm' );
			if ( '' !== value ) {
				_btn.prop( 'disabled', false );
			} else {
				_btn.prop( 'disabled', true );
			}
		} );

		jQuery( 'button.button.bbapp-publish-block__confirm' ).click( function() {
			jQuery( this ).find( '.bbapp_loading' ).show();
			jQuery( this ).addClass( 'btn-disabled' );
		} );
	} );
</script>
