<?php
/**
 * Publish - Connected as secondary site.
 *
 * @package BuddyBossApp\Admin;
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$primary_url       = \BuddyBossApp\ManageApp::instance()->get_primary_site_url();
$primary_admin_url = \BuddyBossApp\ManageApp::instance()->get_primary_site_admin_url();
?>
<div class="bbapp-build-container">
	<div class="bbapp-maintenance-block text-left">
		<div class="bbapp-dev-connect flex">
			<div class="bbapp-left-part">
				<p><?php esc_attr_e( 'New builds can only be published using the BuddyBoss publishing service on your primary site: ', 'buddyboss-app' ); ?><br/>
					<?php
					if ( ! empty( $primary_url ) ) {
						?>
					<a class="link-primary-site" href="<?php echo esc_url( $primary_url ); ?>"><?php echo esc_url( $primary_url ); ?></a></p>
				<?php } ?>
			</div>
			<?php if ( ! empty( $primary_url ) ) { ?>
				<div class="bbapp-right-part">
					<p><a class="button button-secondary" target="_blank" href="<?php echo esc_url( trailingslashit( $primary_admin_url ) . 'wp-admin/admin.php?page=bbapp-publish' ); ?>"><?php esc_html_e( 'Publish Build', 'buddyboss-app' ); ?></a></p>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
