<?php
/**
 * Holds private app popup HTML.
 *
 * @package BuddyBossApp\Admin
 */

?>

<div id="bbapp-modal-box" class="supports-drag-drop bbapp-modal-box bbapp-modal-private-app-box" style="display: none; position: relative;">
	<div tabindex="0" class="media-modal wp-core-ui">
		<div class="media-modal-content">
			<div class="bbapp-modal-body bbapp-modal-box__wrapper">
				<div class="wrap">
					<form name="bbapp-set-menu-priority" id="bbapp-set-menu-priority" method="post">
						<div class="bbapp-modal-box__body">
							<p class="private-app-enabled">
								<?php
								/* translators: %1$s: Access controls page link. */
								echo wp_kses_post( sprintf( __( 'By enabling Private App, your app\'s <a href="%1$s" target="_blank">access rules</a> will be updated to restrict content to logged-in members by default.', 'buddyboss-app' ), esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-access-controls' ) ) ) );
								?>
							</p>
							<p class="private-app-disabled">
								<?php
								/* translators: %1$s: Access controls page link. */
								echo wp_kses_post( sprintf( __( 'By disabling Private App, your app\'s <a href="%1$s" target="_blank">access rules</a> will be updated to allow  everyone access to your content by default.', 'buddyboss-app' ), esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-access-controls' ) ) ) );
								?>
							</p>
							<p><?php echo esc_html__( 'Do you want to continue?', 'buddyboss-app' ); ?></p>
						</div>
						<div class="bbapp-modal-box__footer-private-appp">
							<button type="button" id="bbapp_cancel" class="button bbapp_privat_app_cancel">
								<?php echo esc_html_x( 'Cancel', 'private app popup modal', 'buddyboss-app' ); ?>
							</button>
							<button type="button" id="bbapp_continue" class="button-primary bbapp_privat_app_continue">
								<?php echo esc_html_x( 'Continue', 'private app popup modal', 'buddyboss-app' ); ?>
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<div class="media-modal-backdrop"></div>
</div>
