<?php
/**
 * Holds manage app HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use BuddyBossApp\AppSettings;
use BuddyBossApp\ManageApp;

$app = ManageApp::instance()->get_app();
?>
<div class="buddyboss-app-admin-card">
	<div class="bbapp-connect-app">
		<div class="bbapp-ie">
			<div class="bbapp-ie__heading bbapp-ie__sub">
				<h2 class="title">
					<i class='bb-icon-bf bb-icon-exchange'></i>
					<?php echo esc_html__( 'Connect to BuddyBoss App', 'buddyboss-app' ); ?>

					<?php if ( ! empty( $app['verified'] ) && ! empty( $app['bbapp_site_type'] ) ) : ?>
						<?php if ( 'secondary' === $app['bbapp_site_type'] ) : ?>
							<span class="info-text"><?php esc_html_e( 'Connected as a Secondary Site', 'buddyboss-app' ); ?></span>
						<?php else : ?>
							<span class="info-text"><?php esc_html_e( 'Connected as Primary Site', 'buddyboss-app' ); ?></span>
						<?php endif; ?>
						<?php
						$bbapp_license_type = AppSettings::instance()->get_setting_value( 'app_license_type' );

						if ( ! empty( $bbapp_license_type ) && 'lite' === $bbapp_license_type ) {
							?>
                            <span class="info-text bbapp_no-space"><?php esc_html_e( 'with BuddyBoss App Lite License', 'buddyboss-app' ); ?></span>
							<?php
						} elseif ( ! empty( $bbapp_license_type ) && 'full' === $bbapp_license_type ) {
							?>
                            <span class="info-text bbapp_no-space"><?php esc_html_e( 'with BuddyBoss App Full License', 'buddyboss-app' ); ?></span>
							<?php
						}
						?>
					<?php endif; ?>
				</h2>
			</div>
			<div class="bbapp-ie__block">
				<form name="manageapp" method="post" id="manageapp">
					<div id="manageapp-container">
						<?php require bbapp()->plugin_dir . 'views/settings/connect/main-connect.php'; ?>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>

<script>
	const connectingErrorMsg = <?php echo wp_json_encode( __( 'Error while performing action. Please try again later.', 'buddyboss-app' ) ); ?>;
	const disconnectAlertMsg = <?php echo wp_json_encode( __( 'Are you sure you want to disconnect all of your sites? All builds of your app will stop functioning immediately. Your app will remain live for another 48 hours to allow you time to reconnect, if needed. After that, your app will also disconnect.', 'buddyboss-app' ) ); ?>;
	const disconnectingErrorMsg = <?php echo wp_json_encode( __( 'Error while performing action. Please try again later.', 'buddyboss-app' ) ); ?>;
	const disconnectingText = <?php echo wp_json_encode( __( 'Disconnecting', 'buddyboss-app' ) ); ?>;
	jQuery( document ).ready( function() {
		jQuery( '#manageapp' ).submit( function( e ) {
			e.preventDefault();

			const _this = jQuery( this );
			const submitbtn = _this.find( '.submitbtn' );
			const dotype = _this.find( '.dotype' ).val();
			submitbtn.prop( 'disabled', true );

			// Confirmation alert for disconnecting all sites.
			let ask;
			if( 'disconnect' === dotype ) {
				// eslint-disable-next-line no-alert
				ask = confirm( disconnectAlertMsg );
			} else {
				ask = true;
			}

			if( ask ) {
				const post = jQuery.post( ajaxurl, _this.serialize() );

				post.always( function() {
					submitbtn.prop( 'disabled', false );
				} );

				post.done( function( data ) {
					if( ! data ) {
						// eslint-disable-next-line no-alert
						alert( connectingErrorMsg );
						return false;
					}

					if( data.success ) {
						jQuery( '#manageapp-container' ).html( data.data.message );
						jQuery( '#bbapp-site-connect-notice' ).remove();
                        location.reload();
					} else if( 'primary_not_possible' === data.data.code ) {
						jQuery( '#manageapp-container' ).html( data.data.message );
					} else {
						// eslint-disable-next-line no-alert
						alert( data.data.message );
					}
				} );
				post.error( function() {
					// eslint-disable-next-line no-alert
					alert( connectingErrorMsg );
				} );
			} else {
				submitbtn.prop( 'disabled', false );
			}
		} );

		jQuery( document ).on( 'click', '.app-connect-secondary-btn', function( e ) {
			e.preventDefault();
			jQuery( '#manageapp' ).submit();
		} );

		jQuery( document ).on( 'click', '.disconnect-secondary-site', function( e ) {
			e.preventDefault();

			const _this = jQuery( this );

			if( _this.hasClass( 'disconnecting' ) ) {
				return false;
			}

			_this.addClass( 'disconnecting' );
			_this.text( disconnectingText );

			const post = jQuery.post( ajaxurl, {
				action: 'bbapp_site_disconnect',
				_wpnonce: _this.closest( 'form' ).find( '#_wpnonce' ).val(),
				app_id: _this.data( 'app-id' ),
				site_url: _this.data( 'site-url' ),
			} );

			post.always( function() {
				_this.removeClass( 'disconnecting' );
			} );

			post.done( function( data ) {
				if( ! data ) {
					// eslint-disable-next-line no-alert
					alert( disconnectingErrorMsg );
					return false;
				}

				if( data.success ) {
					_this.closest( '.secondary-site-row' ).remove();
				} else if( data.data.message ) {
					// eslint-disable-next-line no-alert
					alert( data.data.message );
				} else {
					// eslint-disable-next-line no-alert
					alert( disconnectingErrorMsg );
				}
			} );
			post.error( function() {
				// eslint-disable-next-line no-alert
				alert( connectingErrorMsg );
			} );
		} );

		jQuery( document ).on( 'click', '.app-connect-secondary-btn-cancel', function( e ) {
			e.preventDefault();

			const _this = jQuery( this );

			if( _this.hasClass( 'cancelled' ) ) {
				return false;
			}

			_this.addClass( 'cancelled' );

			const get = jQuery.get( ajaxurl, { action: 'bbapp_secondary_site_cancel' } );

			get.always( function() {
				_this.removeClass( 'cancelled' );
			} );

			get.done( function( data ) {
				if( data.success ) {
					jQuery( '#manageapp-container' ).html( data.data.message );
				} else if( data.data.message ) {
					// eslint-disable-next-line no-alert
					alert( data.data.message );
				} else {
					// eslint-disable-next-line no-alert
					alert( disconnectingErrorMsg );
				}
			} );
			get.error( function() {
				// eslint-disable-next-line no-alert
				alert( connectingErrorMsg );
			} );
		} );
	} );

</script>
