<?php
/**
 * Holds home page popup HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly
?>
<li id="item-<?php echo esc_attr( $index ); ?>"
	class="menu-item menu-item-edit-inactive">
	<div class="menu-item-bar">
		<div class="menu-item-handle">
			<span class="item-title">
				<span class="menu-item-title">
					<?php echo esc_html( $setting['settings']['widget_title'] ); ?>
				</span>
			</span>
			<span class="item-controls">
				<button type="button" id="edit-<?php echo esc_attr( $index ); ?>" class="item-edit bbapp-widget-edit hide-if-no-js" aria-label="<?php esc_attr_e( 'Edit item', 'buddyboss-app' ); ?>" aria-expanded="true">
					<span class="dashicons dashicons-arrow-down"></span>
				</button>
			</span>
		</div>
	</div>

	<div class="item-settings wp-clearfix" id="item-settings-<?php echo esc_attr( $index ); ?>">
		<?php
		call_user_func(
			array( 'bbapp_' . $setting['widget_type'] . '_widget', 'metabox' ),
			$index,
			$setting
		);
		?>
		<div class="item-actions submitbox">
			<a class="item-delete submitdelete deletion" href="#"><?php esc_html_e( 'Remove', 'buddyboss-app' ); ?></a>
			<span class="meta-sep hide-if-no-js"> | </span>
			<a class="item-cancel submitcancel hide-if-no-js" href="#">
				<?php esc_html_e( 'Cancel', 'buddyboss-app' ); ?>
			</a>
		</div>
</li>
