<?php
/**
 * Holds textarea field HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( $field['placeholder'] ) {
	$field['placeholder'] = esc_attr( $field['placeholder'] );
}

$max_length = '';

if ( isset( $field['maxlength'] ) ) {
	$max_length = ' maxlength="' . intval( $field['maxlength'] ) . '"';
}
?>

<textarea name="<?php echo esc_attr( $field['name'] ); ?>" <?php disabled( $field['disabled'] ); ?> rows="5" cols="50" class="large-text" <?php echo ( $field['placeholder'] ) ? "placeholder='" . esc_attr( $field['placeholder'] ) . "'" : ''; ?> <?php echo esc_attr( $max_length ); ?> ><?php echo esc_textarea( $field['value'] ); ?></textarea>
