<?php
/**
 * Holds text field HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( $field['placeholder'] ) {
	$field['placeholder'] = esc_attr( $field['placeholder'] );
}

$max_length = '';

if ( isset( $field['maxlength'] ) ) {
	$max_length = ' maxlength="' . intval( $field['maxlength'] ) . '"';
}

$disabled = esc_attr( is_callable( $field['disabled'] ) && ! is_string( $field['disabled'] ) ? $field['disabled']() : $field['disabled'] );
$value    = is_callable( $field['value'] ) && ! is_string( $field['value'] ) ? $field['value']() : $field['value'];
?>

<input name="<?php echo esc_attr( $field['name'] ); ?>" type="text" value="<?php echo esc_attr( $value ); ?>" class="bbapp_field_<?php echo esc_attr( $field['id'] ); ?> regular-text" <?php disabled( $disabled ); ?> <?php echo ( $field['placeholder'] ) ? "placeholder='" . esc_attr( $field['placeholder'] ) . "'" : ''; ?> <?php echo esc_attr( $max_length ); ?>>
