<?php
/**
 * This tab.php use for create new tabs on FormProvider class.
 *
 * @package BuddyBossApp/Admin/FormProvider.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<ul class="bbapp-admin-tabs bbapp_field_<?php echo esc_attr( $field['id'] ); ?>" id="<?php echo esc_attr( $field['id'] ); ?>">
	<?php
	$selected     = false;
	$provider     = ! empty( $field['provider'] ) ? $field['provider'] : '';
	$current_tabs = ! empty( $field['default_tab'] ) ? $field['default_tab'] : '';
	if ( ! empty( $field['tabs'] ) ) {
		foreach ( $field['tabs'] as $key => $tab_item ) {
			$selected = ( false === $selected && $key === $current_tabs ) ? true : $selected;
			echo sprintf( '<li id="%1$s" %2$s>%3$s</li>', esc_attr( $provider . '_' . $key ), ( $key === $current_tabs ? 'class="selected"' : '' ), esc_html( $tab_item ) );
		}
	}
	?>
</ul>
