<?php
/**
 * Holds select field HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$field['options']          = is_callable( $field['options'] ) && ! is_string( $field['options'] ) ? $field['options']() : $field['options'];
$field['disabled_options'] = ( isset( $field['disabled_options'] ) && ! empty( $field['disabled_options'] ) )
    ? (
        is_callable( $field['disabled_options'] ) && ! is_string( $field['disabled_options'] ) 
            ? (array) $field['disabled_options']() 
            : (array) $field['disabled_options']
    )
    : array();

if ( ! empty( $field['select_class'] ) ) {
	$field['select_class'] = $field['select_class'];
	if ( is_array( $field['select_class'] ) ) {
		$field['select_class'] = implode( ' ', $field['select_class'] );
	}
} else {
    $field['select_class'] = '';
}

if ( isset( $field['pre_text'] ) && ! empty( $field['pre_text'] ) ) { ?>
	<label class="pre-select-label">
		<?php echo esc_html( $field['pre_text'] ); ?>
	</label>
<?php } ?>

<select class="bbapp_field_<?php echo esc_attr( $field['id'] ); ?> <?php echo esc_attr($field['select_class']); ?>" name="<?php echo esc_attr( $field['name'] ); ?>" <?php disabled( $field['disabled'] ); ?>>
	<?php
	foreach ( $field['options'] as $option_value => $option_label ) {
		$is_disabled = disabled( in_array( $option_value, $field['disabled_options'] ), true, false );
		$is_selected = $is_disabled ? '' : selected( $option_value, $field['value'], false );
		echo '<option ' . esc_attr( $is_selected ) . ' value="' . esc_attr( $option_value ) . '" ' . esc_attr( $is_disabled ) . '>' . esc_html( $option_label ) . '</option>';
	}
	?>
</select>

<?php if ( isset( $field['post_text'] ) && ! empty( $field['post_text'] ) ) { ?>
	<label class="post-select-label">
		<?php echo esc_html( $field['post_text'] ); ?>
	</label>
	<?php
}
