<?php
/**
 * Holds radio HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$options = ( isset( $field['options'] ) ? $field['options'] : array() );

if ( ! empty( $options ) ) {
	foreach ( $options as $key => $option ) {
		?>
        <p>
        <input id="bbapp_field_<?php echo esc_attr( $key . $field['id'] ); ?>"
               class="regular-text bbapp_field_<?php echo esc_attr( $key . $field['id'] ); ?>"
               name="<?php echo esc_attr( $field['name'] ); ?>" type="radio"
               value="<?php echo esc_attr( $key ); ?>"
			<?php checked( $key, $field['value'] ); ?>
			<?php disabled( $field['disabled'], $key ); ?>
        />
		<?php
		if ( is_array( $option ) && ! empty( $option['label'] ) ) { ?>
            <label for="bbapp_field_<?php echo esc_attr( $key . $field['id'] ); ?>">
				<?php echo wp_kses_post( $option['label'] ); ?>
            </label>
			<?php
			if ( ! empty( $option['description'] ) ) {
				?>
                <div class="bbapp-radio-option-desc">
                    <p class="description">
						<?php echo wp_kses_post( $option['description'] ); ?>
                    </p>
                </div>
				<?php
			}
		} else {
			?>
            <label for="bbapp_field_<?php echo esc_attr( $key . $field['id'] ); ?>">
				<?php echo wp_kses_post( $option ); ?>
            </label>
			<?php
		}
		?>
        </p>
		<?php
	}
}
?>
