<?php
/**
 * Holds password field HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( $field['placeholder'] ) {
	$field['placeholder'] = esc_attr( $field['placeholder'] );
}

$max_length = '';

if ( isset( $field['maxlength'] ) ) {
	$max_length = ' maxlength="' . intval( $field['maxlength'] ) . '"';
}
$value = is_callable( $field['value'] ) && ! is_string( $field['value'] ) ? $field['value']() : $field['value'];
?>

<div class="bbapp-password">
    <div class="bbapp-password__block">
	    <input name="<?php echo esc_attr( $field['name'] ); ?>" type="password" value="<?php echo esc_attr( $value ); ?>" id="<?php echo esc_attr( $field['id'] ); ?>" class="bbapp_field_<?php echo esc_attr( $field['id'] ); ?> bbapp_password_field regular-text" <?php disabled( $field['disabled'] ); ?> <?php echo ( $field['placeholder'] ) ? "placeholder='" . esc_attr( $field['placeholder'] ) . "'" : ''; ?> <?php echo esc_attr( $max_length ); ?> autocomplete="off">

	    <button type="button" class="button button-secondary bbapp-hide-pw hide-if-no-js" data-toggle="0" aria-label="<?php esc_html_e( 'Show password', 'buddyboss-app' ); ?>">
            <span class="bb-icon bb-icon-eye-small" aria-hidden="true"></span>
        </button>
    </div>
</div>
