<?php
/**
 * Holds multiple image picker HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<button class="bbapp_multiple_wp_media_picker">
	<i class="bb-icon-rf bb-icon-images"></i> <?php esc_html_e( 'Browse', 'buddyboss-app' ); ?>
</button>
<?php

if ( ! empty( $field['value'] ) ) {
	?>
	<div class="bbapp-meida-placeholder">
		<?php
		foreach ( $field['value'] as $key => $image ) {
			?>
		<input class="bbapp_field_<?php echo esc_attr( $field['id'] ); ?>" name="<?php echo esc_attr( $field['name'] ); ?>[]" type="hidden" value="<?php echo esc_attr( $image ); ?>" class="regular-text" <?php disabled( $field['disabled'] ); ?>>
		<div class="bbapp-meida-image-preview">
		<img width="50" height="50" src="<?php echo esc_url( wp_get_attachment_url( $image ) ); ?>" >
		<span class="delete-image" >X</span>
	</div>
	<?php } ?>
	</div>
	<?php
} else {
	?>
	<div class="bbapp-meida-placeholder">
		<input class="bbapp_field_<?php echo esc_attr( $field['id'] ); ?>" name="<?php echo esc_attr( $field['name'] ); ?>[]" type="hidden" value="" class="regular-text" <?php disabled( $field['disabled'] ); ?>>
	</div>
<?php } ?>
