<?php
/**
 * Holds multi checkbox HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

foreach ( $field['options'] as $option_value => $option_label ) {
	$checked = '';

	if ( in_array( $option_value, $field['value'] ) || isset( $field['value'][ $option_value ] ) ) { //phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
		$checked = "checked='checked'";
	}
	?>
	<label>
		<input class="bbapp_field_<?php echo esc_attr( $field['id'] ); ?>" name="<?php echo esc_attr( $field['name'] ); ?>[<?php echo esc_attr( $option_value ); ?>]" type="checkbox" value="1" <?php echo esc_attr( $checked ); ?>class="regular-text" <?php disabled( $field['disabled'] ); ?>> <?php echo wp_kses_post( $option_label ); ?>
	</label>
	<br/>
<?php } ?>
