<?php
/**
 * Holds image picker HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

wp_enqueue_media();

$input_cls    = ( $field['show_preview'] ) ? 'bbapp-hide' : '';
$selected_cls = ( $field['value'] ) ? 'selected' : '';
$preview_cls  = ( $field['value'] ) ? 'has-preview' : '';
$button_label = ( !empty($field['button_label']) ) ? $field['button_label'] : __('Browse', 'buddyboss-app' );

if ( $field['show_preview'] ) {
	printf( '<div class="bbapp-preview-wrp %1$s"><img src="%2$s" class="bbapp-image-preview"></div>', esc_attr( $preview_cls ), esc_url( $field['value'] ) );
}
?>
<input class="bbapp_field_<?php echo esc_attr( $field['id'] ); ?> <?php echo esc_attr( $input_cls ); ?>"
		name="<?php echo esc_attr( $field['name'] ); ?>"
		type="text" value="<?php echo esc_attr( $field['value'] ); ?>"
		class="regular-text" <?php disabled( $field['disabled'] ); ?>>
<button class="bbapp_wp_media_picker <?php echo esc_attr( $selected_cls ); ?>">
	<i class="bb-icon-rf bb-icon-images"></i> <?php echo esc_html( $button_label ); ?>
</button>
<?php
$preview_btn_cls = ( empty( $field['value'] ) ) ? 'bbapp-hide' : '';

if ( $field['show_preview'] ) {
	?>
	<button class="bbapp_wp_media_delete <?php echo esc_attr( $preview_btn_cls ); ?>">
		<?php esc_html_e( 'Remove', 'buddyboss-app' ); ?>
	</button>
	<?php
}

