<?php
/**
 * Holds heading field HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<h2 id="<?php echo esc_attr( $field['id'] ); ?>" class="title <?php echo esc_attr( 'bbapp_field_' . $field['id'] ) . ( ! empty( $field['tutorial_url'] ) ? ' has_tutorial_url' : '' ); ?>">
	<?php

	// Show icon if it's set.
	if ( ! empty( $field['icon'] ) ) {
		echo '<i class="' . esc_attr( $field['icon'] ) . '"></i>';
	}

	if ( is_callable( $field['value'] ) && ! is_string( $field['value'] ) ) {
		echo wp_kses_post( $field['value']() );
	} else {
		echo esc_html( $field['value'] );
	}

	// Tutorial link setup.
	if ( ! empty( $field['tutorial_url'] ) ) {
		$tutorial_label = ! empty( $field['tutorial_label'] ) 
			? esc_html( $field['tutorial_label'] ) 
			: esc_html__( 'View Tutorial', 'buddyboss-app' );

		$target_type = ! empty( $field['tutorial_target_type'] ) ? $field['tutorial_target_type'] : '_blank';

		printf(
			'<a class="button button-secondary bbapp-tutorial-btn" href="%s" target="%s">%s</a>',
			esc_url( $field['tutorial_url'] ),
			esc_attr( $target_type ),
			esc_html( $tutorial_label )
		);
	}
	?>
</h2>
