<?php
/**
 * Holds custom selector section HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! empty( $sections ) ) {
	foreach ( $sections as $section ) {
		$placeholder = ! empty( $section['placeholder'] ) ? $section['placeholder'] : __( 'Search', 'buddyboss-app' );
		$position    = ! empty( $section['position'] ) ? $section['position'] : 'left';

		if ( ( 'left' === $position ) || ( 'right' === $position ) ) {
			$html_slug      = ! empty( $section['html_slug'] ) ? $section['html_slug'] : 'bbapp_all';
			$selector_posts = ! empty( $section['posts'] ) ? $section['posts'] : array();

			?>
			<td class="bbapp-selector-section bbapp-selector-section-<?php echo esc_attr( $position ); ?>">
				<input placeholder="<?php echo esc_attr( $placeholder ); ?>" type="text" id="bbapp-selector-search-<?php echo esc_attr( $html_slug ); ?>-<?php echo esc_attr( $position ); ?>" class="bbapp-selector-search bbapp-selector-search-<?php echo esc_attr( $position ); ?>"/>
				<select multiple="multiple" class="bbapp-selector-items bbapp-selector-items-<?php echo esc_attr( $position ); ?>">
					<?php
					if ( isset( $settings['options_html_callback'] ) && is_callable( $settings['options_html_callback'] ) ) {
						echo $settings['options_html_callback']( $selector_posts, $position ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					}
					?>
				</select>
				<ul class="bbapp-selector-pager bbapp-selector-pager-<?php echo esc_attr( $position ); ?>">
					<?php if ( ! empty( $selector_posts ) ) { ?>
						<li class="bbapp-selector-pager-prev">
							<a class="bbapp-selector-pager-prev button" style="display:none;" href="#">
								<?php esc_html_e( '&lsaquo; prev', 'buddyboss-app' ); ?>
							</a>
						</li>
						<li class="bbapp-selector-pager-info" style="display:none;">
							<?php
							/* translators: %1$s: Current page, %2$s: Total pages. */
							echo sprintf( '<div class="bbapp-selector-pagination">' . esc_html_x( '%1$s of %2$s', 'placeholder: Page X of Y', 'buddyboss-app' ) . '</div>', '<span class="current_page"></span>', '<span class="total_pages"></span>' );
							?>
						</li>
						<li class="bbapp-selector-pager-next">
							<a class="bbapp-selector-pager-next button" style="display:none;" href="#">
								<?php esc_html_e( 'next &rsaquo;', 'buddyboss-app' ); ?>
							</a>
						</li>
					<?php } ?>
				</ul>
			</td>
			<?php
		} else {
			?>
			<td class="bbapp-selector-section bbapp-selector-section-middle">
				<a href="#" class="bbapp-selector-button-add">
					<?php if ( is_rtl() ) { ?>
						<i class='bb-icon-rf bb-icon-arrow-left'></i>
					<?php } else { ?>
						<i class='bb-icon-rf bb-icon-arrow-right'></i>
					<?php } ?>
				</a>
				<br>
				<a href="#" class="bbapp-selector-button-remove">
					<?php if ( is_rtl() ) { ?>
						<i class='bb-icon-rf bb-icon-arrow-right'></i>
					<?php } else { ?>
						<i class='bb-icon-rf bb-icon-arrow-left'></i>
					<?php } ?>
				</a>
			</td>
			<?php
		}
	}
}
