<?php
/**
 * Holds settings checkbox field HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<input id="bbapp_field_<?php echo esc_attr( $field['id'] ); ?>" class="regular-text bbapp_field_<?php echo esc_attr( $field['id'] ); ?>" name="<?php echo esc_attr( $field['name'] ); ?>" type="checkbox" value="1" <?php checked( true, $field['value'] ); ?> <?php disabled( $field['disabled'] ); ?>>

<?php if ( isset( $field['label_checkbox'] ) ) { ?>
	<label for="bbapp_field_<?php echo esc_attr( $field['id'] ); ?>">
		<?php echo wp_kses_post( $field['label_checkbox'] ); ?>
	</label>
<?php } ?>
