<?php
/**
 * Connect App - Secondary Site Confirm.
 *
 * @package BuddyBossApp\Admin
 */

$app_info = \BuddyBossApp\ManageApp::instance()->get_app_info();
if ( ! is_wp_error( $app_info ) && ! empty( $app_info['secondary_sites'] ) ) :
	?>
	<table class="form-table">
		<tbody>
		<?php foreach ( $app_info['secondary_sites'] as $secondary_site ) : ?>
			<tr class="bbapp_field_wrapper secondary-site-row">
				<td>
					<a href="<?php echo ! empty( $secondary_site->url ) ? esc_url( $secondary_site->url ) : '#'; ?>" target="_blank"><?php echo ! empty( $secondary_site->url ) ? esc_url( $secondary_site->url ) : ''; ?></a>
				</td>
				<td>
					<a href="javascript:void()" class="disconnect-secondary-site" data-site-url="<?php echo ! empty( $secondary_site->url ) ? esc_url( $secondary_site->url ) : ''; ?>"><?php esc_html_e( 'Disconnect', 'buddyboss-app' ); ?></a>
				</td>
			</tr>
		<?php endforeach; ?>
		</tbody>
	</table>
<?php endif; ?>
