<?php
/**
 * Connect App - Secondary Site Confirm.
 *
 * @package BuddyBossApp\Admin
 */

$bb_app_id  = ! empty( $_POST['bbapp_app_id'] ) ? bbapp_input_clean( wp_unslash( $_POST['bbapp_app_id'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$bb_app_key = ! empty( $_POST['bbapp_app_key'] ) ? bbapp_input_clean( wp_unslash( $_POST['bbapp_app_key'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
?>
<div>
	<p><?php esc_html_e( 'This App ID and Key is already connected to a primary site. If you\'d like to use this site as your primary site, please disconnect your current primary site first.', 'buddyboss-app' ); ?></p>
	<p><?php esc_html_e( 'Alternatively, you can connect this site as a secondary site. Secondary sites can only be connected to test app builds.', 'buddyboss-app' ); ?></p>
	<p><?php esc_html_e( 'Would you like to connect this site as secondary site?', 'buddyboss-app' ); ?></p>
	<input type="hidden" class="dotype" name="do" value="connect"/>
	<input type="hidden" name="bbapp_site_type" value="secondary"/>
	<?php wp_nonce_field( 'bbapp_manage_app_nonce' ); ?>
	<input type="hidden" name="action" value="bbapp_app_connection"/>
	<input type="hidden" name="bbapp_app_id" value="<?php echo esc_attr( $bb_app_id ); ?>"/>
	<input type="hidden" name="bbapp_app_key" value="<?php echo esc_attr( $bb_app_key ); ?>"/>
	<a href="#" class="button button-primary app-connect-secondary-btn"><?php echo esc_html__( 'Yes', 'buddyboss-app' ); ?></a>
	<a href="#" class="button app-connect-secondary-btn-cancel"><?php echo esc_html__( 'Cancel', 'buddyboss-app' ); ?></a>
</div>
