<?php
/**
 * Connect App - Main form
 *
 * @package BuddyBossApp\Admin
 */

use BuddyBossApp\AppSettings;
use BuddyBossApp\ManageApp;

$app             = ManageApp::instance()->get_app();
$verified        = isset( $app['verified'] ) ? $app['verified'] : false;
$bbapp_app_id    = ! empty( $app['bbapp_app_id'] ) ? $app['bbapp_app_id'] : '';
$bbapp_app_key   = ! empty( $app['bbapp_app_key'] ) ? $app['bbapp_app_key'] : '';
$bbapp_site_type = ! empty( $app['bbapp_site_type'] ) ? $app['bbapp_site_type'] : '';

if ( empty( $verified ) ) : ?>
	<p><?php printf( '%1$s <a href="https://my.buddyboss.com/?tab=mysubscriptions&sub_tab=apps" target="_blank">%2$s</a> %3$s', esc_html__( 'To start using this site in your BuddyBoss App, please connect this site to your BuddyBoss account. You can find this information on the', 'buddyboss-app' ), esc_html__( 'Subscriptions', 'buddyboss-app' ), esc_html__( 'page in your BuddyBoss account.', 'buddyboss-app' ) ); ?></p>
	<?php
endif;
if ( empty( $bbapp_site_type ) || 'primary' === $bbapp_site_type ) :
	?>
	<table class="form-table">
		<tbody>
		<tr class="bbapp_field_wrapper">
			<th scope="row" style="width:250px">
				<label><?php echo esc_html__( 'BuddyBoss App ID', 'buddyboss-app' ); ?></label>
			</th>
			<td>
				<input name="bbapp_app_id" type="text" class="regular-text" value="<?php echo esc_attr( $bbapp_app_id ); ?>" <?php disabled( $verified, 1 ); ?>/>
			</td>
		</tr>
		<tr class="bbapp_field_wrapper">
			<th scope="row" style="width:250px">
				<label><?php echo esc_html__( 'BuddyBoss App Key', 'buddyboss-app' ); ?></label>
			</th>
			<td>
				<div class="bbapp-password bbapp-app-key">
					<div class="bbapp-password__block">
						<input name="bbapp_app_key" type="password" class="regular-text bbapp_password_field" value="<?php echo esc_attr( $bbapp_app_key ); ?>" <?php disabled( $verified, 1 ); ?>/>
						<button type="button" class="button button-secondary bbapp-hide-pw hide-if-no-js"
								data-toggle="0" aria-label="<?php esc_html_e( 'Show password', 'buddyboss-app' ); ?>">
							<span class="bb-icon-l bb-icon-eye" aria-hidden="true"></span>
						</button>
					</div>
				</div>
			</td>
		</tr>
		</tbody>
	</table>
<?php elseif ( 'secondary' === $bbapp_site_type ) : ?>
	<div>
		<?php
		$app_info     = \BuddyBossApp\ManageApp::instance()->get_app_info();
		$primary_site = ! is_wp_error( $app_info ) && isset( $app_info['primary_site']->url ) ? $app_info['primary_site']->url : '';

		/* translators: %1$s: Primary site link text, %2$s: Primary site link. */
		printf( '%1$s <a href="%2$s" target="_blank">%2$s</a>', esc_html__( 'This site is set as a secondary site to your primary site:', 'buddyboss-app' ), esc_url( $primary_site ) );
		?>
	</div>
	<br/>
<?php endif; ?>

<?php wp_nonce_field( 'bbapp_manage_app_nonce' ); ?>

<input type="hidden" name="action" value="bbapp_app_connection"/>
<input type="hidden" name="bbapp_site_type" value="<?php echo $verified ? esc_attr( $bbapp_site_type ) : esc_attr( 'primary' ); ?>"/>

<?php if ( ! empty( $app['verified'] ) ) { ?>
	<input type="hidden" class="dotype" name="do" value="disconnect"/>
	<button type="submit" name="submit"
			class="button button-primary submitbtn app-disconnect-btn"><?php echo esc_html__( 'Disconnect', 'buddyboss-app' ); ?></button>
<?php } else { ?>
	<input type="hidden" class="dotype" name="do" value="connect"/>
	<button type="submit" name="submit"
			class="button button-primary submitbtn app-connect-btn"><?php echo esc_html__( 'Connect', 'buddyboss-app' ); ?></button>
<?php } ?>

<a href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-help&article=122272' ) ); ?>" class="button view_tutorial" target="_blank"><?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?></a>

<br/>
<br/>

<?php if ( 'primary' === $bbapp_site_type ) : ?>
	<p class="bbapp-notice-box bbapp-notice-box--info">
		<b><?php esc_html_e( 'Warning:', 'buddyboss-app' ); ?></b>&nbsp;<?php esc_html_e( 'Clicking "Disconnect" will immediately disconnect your primary and all your secondary sites from the app. All builds of your app will stop functioning correctly as it will lose all communication with your WordPress database.', 'buddyboss-app' ); ?>
	</p>
	<h3><?php esc_html_e( 'Secondary Sites', 'buddyboss-app' ); ?></h3>
	<p><?php esc_html_e( 'You can connect your app to secondary sites, such as staging and development environments. These sites can only be connected to test app builds.', 'buddyboss-app' ); ?></p>
	<p><?php esc_html_e( 'To set up a secondary site, install the BuddyBoss App Plugin on it and connect using your App ID and App Key.', 'buddyboss-app' ); ?></p>

	<?php include bbapp()->plugin_dir . 'views/settings/connect/secondary-sites.php'; ?>
<?php elseif ( 'secondary' === $bbapp_site_type ) : ?>
	<p class="bbapp-notice-box bbapp-notice-box--info">
		<b><?php esc_html_e( 'Warning:', 'buddyboss-app' ); ?></b>&nbsp;<?php esc_html_e( 'Clicking "Disconnect" will immediately prevent access to this site in your test app builds.', 'buddyboss-app' ); ?>
	</p>
	<?php
endif;

$token_get = ! empty( $_REQUEST['get_token'] ) && true === (bool) $_REQUEST['get_token'];

if ( $token_get ) {
	?>
    <p class="bbapp-notice-box bbapp-notice-box--info" style="line-break: anywhere;">
        <b><?php esc_html_e( 'Token:', 'buddyboss-app' ); ?></b>&nbsp;
		<?php echo esc_html( AppSettings::instance()->get_setting_value( 'license_data_token' ) ); ?>
    </p>
	<?php
}
